
package org.hibernate.jpamodelgen.xml.jaxb;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         @Target({METHOD, FIELD}) @Retention(RUNTIME)
 *         public @interface ManyToMany {
 *           Class targetEntity() default void.class;
 *           CascadeType[] cascade() default {};
 *           FetchType fetch() default LAZY;
 *           String mappedBy() default "";
 *         }
 * 
 *       
 * 
 * <p>Java class for many-to-many complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="many-to-many">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <choice>
 *           <element name="order-by" type="{https://jakarta.ee/xml/ns/persistence/orm}order-by" minOccurs="0"/>
 *           <element name="order-column" type="{https://jakarta.ee/xml/ns/persistence/orm}order-column" minOccurs="0"/>
 *         </choice>
 *         <choice>
 *           <element name="map-key" type="{https://jakarta.ee/xml/ns/persistence/orm}map-key" minOccurs="0"/>
 *           <sequence>
 *             <element name="map-key-class" type="{https://jakarta.ee/xml/ns/persistence/orm}map-key-class" minOccurs="0"/>
 *             <choice>
 *               <element name="map-key-temporal" type="{https://jakarta.ee/xml/ns/persistence/orm}temporal" minOccurs="0"/>
 *               <element name="map-key-enumerated" type="{https://jakarta.ee/xml/ns/persistence/orm}enumerated" minOccurs="0"/>
 *               <sequence>
 *                 <element name="map-key-attribute-override" type="{https://jakarta.ee/xml/ns/persistence/orm}attribute-override" maxOccurs="unbounded" minOccurs="0"/>
 *                 <element name="map-key-convert" type="{https://jakarta.ee/xml/ns/persistence/orm}convert" maxOccurs="unbounded" minOccurs="0"/>
 *               </sequence>
 *             </choice>
 *             <choice>
 *               <element name="map-key-column" type="{https://jakarta.ee/xml/ns/persistence/orm}map-key-column" minOccurs="0"/>
 *               <sequence>
 *                 <element name="map-key-join-column" type="{https://jakarta.ee/xml/ns/persistence/orm}map-key-join-column" maxOccurs="unbounded" minOccurs="0"/>
 *                 <element name="map-key-foreign-key" type="{https://jakarta.ee/xml/ns/persistence/orm}foreign-key" minOccurs="0"/>
 *               </sequence>
 *             </choice>
 *           </sequence>
 *         </choice>
 *         <element name="join-table" type="{https://jakarta.ee/xml/ns/persistence/orm}join-table" minOccurs="0"/>
 *         <element name="cascade" type="{https://jakarta.ee/xml/ns/persistence/orm}cascade-type" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="target-entity" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="fetch" type="{https://jakarta.ee/xml/ns/persistence/orm}fetch-type" />
 *       <attribute name="access" type="{https://jakarta.ee/xml/ns/persistence/orm}access-type" />
 *       <attribute name="mapped-by" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "many-to-many", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "orderBy",
    "orderColumn",
    "mapKey",
    "mapKeyClass",
    "mapKeyTemporal",
    "mapKeyEnumerated",
    "mapKeyAttributeOverride",
    "mapKeyConvert",
    "mapKeyColumn",
    "mapKeyJoinColumn",
    "mapKeyForeignKey",
    "joinTable",
    "cascade"
})
public class ManyToMany {

    @XmlElement(name = "order-by", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String orderBy;
    @XmlElement(name = "order-column", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected OrderColumn orderColumn;
    @XmlElement(name = "map-key", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected MapKey mapKey;
    @XmlElement(name = "map-key-class", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected MapKeyClass mapKeyClass;
    @XmlElement(name = "map-key-temporal", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    @XmlSchemaType(name = "token")
    protected TemporalType mapKeyTemporal;
    @XmlElement(name = "map-key-enumerated", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    @XmlSchemaType(name = "token")
    protected EnumType mapKeyEnumerated;
    @XmlElement(name = "map-key-attribute-override", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<AttributeOverride> mapKeyAttributeOverride;
    @XmlElement(name = "map-key-convert", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<Convert> mapKeyConvert;
    @XmlElement(name = "map-key-column", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected MapKeyColumn mapKeyColumn;
    @XmlElement(name = "map-key-join-column", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<MapKeyJoinColumn> mapKeyJoinColumn;
    @XmlElement(name = "map-key-foreign-key", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected ForeignKey mapKeyForeignKey;
    @XmlElement(name = "join-table", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected JoinTable joinTable;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected CascadeType cascade;
    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "target-entity")
    protected String targetEntity;
    @XmlAttribute(name = "fetch")
    protected FetchType fetch;
    @XmlAttribute(name = "access")
    protected AccessType access;
    @XmlAttribute(name = "mapped-by")
    protected String mappedBy;

    /**
     * Gets the value of the orderBy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrderBy() {
        return orderBy;
    }

    /**
     * Sets the value of the orderBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrderBy(String value) {
        this.orderBy = value;
    }

    /**
     * Gets the value of the orderColumn property.
     * 
     * @return
     *     possible object is
     *     {@link OrderColumn }
     *     
     */
    public OrderColumn getOrderColumn() {
        return orderColumn;
    }

    /**
     * Sets the value of the orderColumn property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrderColumn }
     *     
     */
    public void setOrderColumn(OrderColumn value) {
        this.orderColumn = value;
    }

    /**
     * Gets the value of the mapKey property.
     * 
     * @return
     *     possible object is
     *     {@link MapKey }
     *     
     */
    public MapKey getMapKey() {
        return mapKey;
    }

    /**
     * Sets the value of the mapKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link MapKey }
     *     
     */
    public void setMapKey(MapKey value) {
        this.mapKey = value;
    }

    /**
     * Gets the value of the mapKeyClass property.
     * 
     * @return
     *     possible object is
     *     {@link MapKeyClass }
     *     
     */
    public MapKeyClass getMapKeyClass() {
        return mapKeyClass;
    }

    /**
     * Sets the value of the mapKeyClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link MapKeyClass }
     *     
     */
    public void setMapKeyClass(MapKeyClass value) {
        this.mapKeyClass = value;
    }

    /**
     * Gets the value of the mapKeyTemporal property.
     * 
     * @return
     *     possible object is
     *     {@link TemporalType }
     *     
     */
    public TemporalType getMapKeyTemporal() {
        return mapKeyTemporal;
    }

    /**
     * Sets the value of the mapKeyTemporal property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemporalType }
     *     
     */
    public void setMapKeyTemporal(TemporalType value) {
        this.mapKeyTemporal = value;
    }

    /**
     * Gets the value of the mapKeyEnumerated property.
     * 
     * @return
     *     possible object is
     *     {@link EnumType }
     *     
     */
    public EnumType getMapKeyEnumerated() {
        return mapKeyEnumerated;
    }

    /**
     * Sets the value of the mapKeyEnumerated property.
     * 
     * @param value
     *     allowed object is
     *     {@link EnumType }
     *     
     */
    public void setMapKeyEnumerated(EnumType value) {
        this.mapKeyEnumerated = value;
    }

    /**
     * Gets the value of the mapKeyAttributeOverride property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyAttributeOverride property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyAttributeOverride().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AttributeOverride }
     * 
     * 
     * @return
     *     The value of the mapKeyAttributeOverride property.
     */
    public List<AttributeOverride> getMapKeyAttributeOverride() {
        if (mapKeyAttributeOverride == null) {
            mapKeyAttributeOverride = new ArrayList<>();
        }
        return this.mapKeyAttributeOverride;
    }

    /**
     * Gets the value of the mapKeyConvert property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyConvert property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyConvert().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Convert }
     * 
     * 
     * @return
     *     The value of the mapKeyConvert property.
     */
    public List<Convert> getMapKeyConvert() {
        if (mapKeyConvert == null) {
            mapKeyConvert = new ArrayList<>();
        }
        return this.mapKeyConvert;
    }

    /**
     * Gets the value of the mapKeyColumn property.
     * 
     * @return
     *     possible object is
     *     {@link MapKeyColumn }
     *     
     */
    public MapKeyColumn getMapKeyColumn() {
        return mapKeyColumn;
    }

    /**
     * Sets the value of the mapKeyColumn property.
     * 
     * @param value
     *     allowed object is
     *     {@link MapKeyColumn }
     *     
     */
    public void setMapKeyColumn(MapKeyColumn value) {
        this.mapKeyColumn = value;
    }

    /**
     * Gets the value of the mapKeyJoinColumn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyJoinColumn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyJoinColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MapKeyJoinColumn }
     * 
     * 
     * @return
     *     The value of the mapKeyJoinColumn property.
     */
    public List<MapKeyJoinColumn> getMapKeyJoinColumn() {
        if (mapKeyJoinColumn == null) {
            mapKeyJoinColumn = new ArrayList<>();
        }
        return this.mapKeyJoinColumn;
    }

    /**
     * Gets the value of the mapKeyForeignKey property.
     * 
     * @return
     *     possible object is
     *     {@link ForeignKey }
     *     
     */
    public ForeignKey getMapKeyForeignKey() {
        return mapKeyForeignKey;
    }

    /**
     * Sets the value of the mapKeyForeignKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link ForeignKey }
     *     
     */
    public void setMapKeyForeignKey(ForeignKey value) {
        this.mapKeyForeignKey = value;
    }

    /**
     * Gets the value of the joinTable property.
     * 
     * @return
     *     possible object is
     *     {@link JoinTable }
     *     
     */
    public JoinTable getJoinTable() {
        return joinTable;
    }

    /**
     * Sets the value of the joinTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link JoinTable }
     *     
     */
    public void setJoinTable(JoinTable value) {
        this.joinTable = value;
    }

    /**
     * Gets the value of the cascade property.
     * 
     * @return
     *     possible object is
     *     {@link CascadeType }
     *     
     */
    public CascadeType getCascade() {
        return cascade;
    }

    /**
     * Sets the value of the cascade property.
     * 
     * @param value
     *     allowed object is
     *     {@link CascadeType }
     *     
     */
    public void setCascade(CascadeType value) {
        this.cascade = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the targetEntity property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetEntity() {
        return targetEntity;
    }

    /**
     * Sets the value of the targetEntity property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetEntity(String value) {
        this.targetEntity = value;
    }

    /**
     * Gets the value of the fetch property.
     * 
     * @return
     *     possible object is
     *     {@link FetchType }
     *     
     */
    public FetchType getFetch() {
        return fetch;
    }

    /**
     * Sets the value of the fetch property.
     * 
     * @param value
     *     allowed object is
     *     {@link FetchType }
     *     
     */
    public void setFetch(FetchType value) {
        this.fetch = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link AccessType }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccessType }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the mappedBy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMappedBy() {
        return mappedBy;
    }

    /**
     * Sets the value of the mappedBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMappedBy(String value) {
        this.mappedBy = value;
    }

}
