/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.concurrent.TimeUnit;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;

@NonNullApi
@NonNullFields
public class HibernateQueryMetrics
implements MeterBinder {
    private static final String SESSION_FACTORY_TAG_NAME = "entityManagerFactory";
    private final Iterable<Tag> tags;
    private final SessionFactory sessionFactory;

    public static void monitor(MeterRegistry registry, SessionFactory sessionFactory, String sessionFactoryName, String ... tags) {
        HibernateQueryMetrics.monitor(registry, sessionFactory, sessionFactoryName, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public static void monitor(MeterRegistry registry, SessionFactory sessionFactory, String sessionFactoryName, Iterable<Tag> tags) {
        new HibernateQueryMetrics(sessionFactory, sessionFactoryName, tags).bindTo(registry);
    }

    public HibernateQueryMetrics(SessionFactory sessionFactory, String sessionFactoryName, Iterable<Tag> tags) {
        this.tags = Tags.concat(tags, (String[])new String[]{SESSION_FACTORY_TAG_NAME, sessionFactoryName});
        this.sessionFactory = sessionFactory;
    }

    public void bindTo(MeterRegistry meterRegistry) {
        if (this.sessionFactory instanceof SessionFactoryImplementor) {
            EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)((SessionFactoryImplementor)this.sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
            MetricsEventHandler metricsEventHandler = new MetricsEventHandler(meterRegistry);
            eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{metricsEventHandler});
        }
    }

    class MetricsEventHandler
    implements PostLoadEventListener {
        private final MeterRegistry meterRegistry;

        MetricsEventHandler(MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
        }

        public void onPostLoad(PostLoadEvent event) {
            this.registerQueryMetric((Statistics)event.getSession().getFactory().getStatistics());
        }

        void registerQueryMetric(Statistics statistics) {
            for (String query : statistics.getQueries()) {
                QueryStatistics queryStatistics = statistics.getQueryStatistics(query);
                FunctionCounter.builder((String)"hibernate.query.cache.requests", (Object)queryStatistics, QueryStatistics::getCacheHitCount).tags(HibernateQueryMetrics.this.tags).tags(new String[]{"result", "hit", "query", query}).description("Number of query cache hits").register(this.meterRegistry);
                FunctionCounter.builder((String)"hibernate.query.cache.requests", (Object)queryStatistics, QueryStatistics::getCacheMissCount).tags(HibernateQueryMetrics.this.tags).tags(new String[]{"result", "miss", "query", query}).description("Number of query cache misses").register(this.meterRegistry);
                FunctionCounter.builder((String)"hibernate.query.cache.puts", (Object)queryStatistics, QueryStatistics::getCachePutCount).tags(HibernateQueryMetrics.this.tags).tags(new String[]{"query", query}).description("Number of cache puts for a query").register(this.meterRegistry);
                FunctionTimer.builder((String)"hibernate.query.execution.total", (Object)queryStatistics, QueryStatistics::getExecutionCount, QueryStatistics::getExecutionTotalTime, (TimeUnit)TimeUnit.MILLISECONDS).tags(HibernateQueryMetrics.this.tags).tags(new String[]{"query", query}).description("Query executions").register(this.meterRegistry);
                TimeGauge.builder((String)"hibernate.query.execution.max", (Object)queryStatistics, (TimeUnit)TimeUnit.MILLISECONDS, QueryStatistics::getExecutionMaxTime).tags(HibernateQueryMetrics.this.tags).tags(new String[]{"query", query}).description("Query maximum execution time").register(this.meterRegistry);
                TimeGauge.builder((String)"hibernate.query.execution.min", (Object)queryStatistics, (TimeUnit)TimeUnit.MILLISECONDS, QueryStatistics::getExecutionMinTime).tags(HibernateQueryMetrics.this.tags).tags(new String[]{"query", query}).description("Query minimum execution time").register(this.meterRegistry);
                FunctionCounter.builder((String)"hibernate.query.execution.rows", (Object)queryStatistics, QueryStatistics::getExecutionRowCount).tags(HibernateQueryMetrics.this.tags).tags(new String[]{"query", query}).description("Number of rows processed for a query").register(this.meterRegistry);
            }
        }
    }
}

