/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.common.connections;

import java.sql.Connection;
import java.util.Properties;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.util.PropertiesHelper;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseTransactionIsolationConfigTest
extends BaseUnitTestCase {
    protected abstract ConnectionProvider getConnectionProviderUnderTest();

    protected void augmentConfigurationSettings(Properties properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingIsolationAsNumeric() throws Exception {
        Properties properties = Environment.getProperties();
        this.augmentConfigurationSettings(properties);
        properties.put(" hibernate.connection.isolation", (Object)8);
        ConnectionProvider provider = this.getConnectionProviderUnderTest();
        try {
            ((Configurable)provider).configure(PropertiesHelper.map((Properties)properties));
            if (provider instanceof Startable) {
                ((Startable)provider).start();
            }
            Connection connection = provider.getConnection();
            Assert.assertEquals((long)8L, (long)connection.getTransactionIsolation());
            provider.closeConnection(connection);
        }
        finally {
            ((Stoppable)provider).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingIsolationAsNumericString() throws Exception {
        Properties properties = Environment.getProperties();
        this.augmentConfigurationSettings(properties);
        properties.put(" hibernate.connection.isolation", Integer.toString(8));
        ConnectionProvider provider = this.getConnectionProviderUnderTest();
        try {
            ((Configurable)provider).configure(PropertiesHelper.map((Properties)properties));
            if (provider instanceof Startable) {
                ((Startable)provider).start();
            }
            Connection connection = provider.getConnection();
            Assert.assertEquals((long)8L, (long)connection.getTransactionIsolation());
            provider.closeConnection(connection);
        }
        finally {
            ((Stoppable)provider).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingIsolationAsName() throws Exception {
        Properties properties = Environment.getProperties();
        this.augmentConfigurationSettings(properties);
        properties.put(" hibernate.connection.isolation", "TRANSACTION_SERIALIZABLE");
        ConnectionProvider provider = this.getConnectionProviderUnderTest();
        try {
            ((Configurable)provider).configure(PropertiesHelper.map((Properties)properties));
            if (provider instanceof Startable) {
                ((Startable)provider).start();
            }
            Connection connection = provider.getConnection();
            Assert.assertEquals((long)8L, (long)connection.getTransactionIsolation());
            provider.closeConnection(connection);
        }
        finally {
            ((Stoppable)provider).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingIsolationAsNameAlt() throws Exception {
        Properties properties = Environment.getProperties();
        this.augmentConfigurationSettings(properties);
        properties.put(" hibernate.connection.isolation", "SERIALIZABLE");
        ConnectionProvider provider = this.getConnectionProviderUnderTest();
        try {
            ((Configurable)provider).configure(PropertiesHelper.map((Properties)properties));
            if (provider instanceof Startable) {
                ((Startable)provider).start();
            }
            Connection connection = provider.getConnection();
            Assert.assertEquals((long)8L, (long)connection.getTransactionIsolation());
            provider.closeConnection(connection);
        }
        finally {
            ((Stoppable)provider).stop();
        }
    }
}

