/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.testing.FailureExpected;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public final class Helper {
    public static final String VALIDATE_FAILURE_EXPECTED = "hibernate.test.validatefailureexpected";

    private Helper() {
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static String extractTestName(FrameworkMethod frameworkMethod) {
        return frameworkMethod.getMethod().getDeclaringClass().getName() + "#" + frameworkMethod.getName();
    }

    public static String extractMethodName(Method method) {
        return method.getDeclaringClass().getName() + "#" + method.getName();
    }

    public static <T extends Annotation> T locateAnnotation(Class<T> annotationClass, FrameworkMethod frameworkMethod, TestClass testClass) {
        Annotation annotation = frameworkMethod.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = testClass.getJavaClass().getAnnotation(annotationClass);
        }
        return (T)annotation;
    }

    public static <T extends Annotation> List<T> locateAllAnnotations(Class<T> annotationClass, FrameworkMethod frameworkMethod, TestClass testClass) {
        LinkedList<Annotation> annotations = new LinkedList<Annotation>();
        Annotation annotation = frameworkMethod.getAnnotation(annotationClass);
        if (annotation != null) {
            annotations.add(annotation);
        }
        if ((annotation = testClass.getJavaClass().getAnnotation(annotationClass)) != null) {
            annotations.add(annotation);
        }
        return annotations;
    }

    public static <S extends Annotation, P extends Annotation> List<S> collectAnnotations(Class<S> singularAnnotationClass, Class<P> pluralAnnotationClass, FrameworkMethod frameworkMethod, TestClass testClass) {
        P pluralAnn;
        LinkedList<Object> collection = new LinkedList<Object>();
        S singularAnn = Helper.locateAnnotation(singularAnnotationClass, frameworkMethod, testClass);
        if (singularAnn != null) {
            collection.add(singularAnn);
        }
        if ((pluralAnn = Helper.locateAnnotation(pluralAnnotationClass, frameworkMethod, testClass)) != null) {
            try {
                collection.addAll(Arrays.asList((Annotation[])pluralAnnotationClass.getDeclaredMethods()[0].invoke(pluralAnn, new Object[0])));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return collection;
    }

    public static String extractMessage(FailureExpected failureExpected) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(').append(failureExpected.jiraKey()).append(')');
        if (Helper.isNotEmpty(failureExpected.message())) {
            buffer.append(" : ").append(failureExpected.message());
        }
        return buffer.toString();
    }

    public static String extractIgnoreMessage(FailureExpected failureExpected, FrameworkMethod frameworkMethod) {
        return "Ignoring test [" + Helper.extractTestName(frameworkMethod) + "] due to @FailureExpected - " + Helper.extractMessage(failureExpected);
    }

    public static void createH2Schema(String schemaName, Configuration cfg) {
        Helper.createH2Schema(schemaName, cfg.getProperties());
    }

    public static void createH2Schema(String schemaName, Map settings) {
        settings.put("hibernate.connection.url", settings.get("hibernate.connection.url") + ";INIT=CREATE SCHEMA IF NOT EXISTS " + schemaName);
    }
}

