/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing;

import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.testing.DialectCheck;

public abstract class DialectChecks {

    public static class SupportsValuesListForInsert
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsValuesListForInsert();
        }
    }

    public static class SupportsTemporaryTableIdentity
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsTemporaryTablePrimaryKey();
        }
    }

    public static class SupportsSubqueryInSelect
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsSubqueryInSelect();
        }
    }

    public static class SupportsUnionInSubquery
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsUnionInSubquery();
        }
    }

    public static class SupportsTemporaryTable
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsTemporaryTables();
        }
    }

    public static class SupportsNClob
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.getNationalizationSupport() == NationalizationSupport.EXPLICIT;
        }
    }

    public static class SupportsNoColumnInsert
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsNoColumnsInsert();
        }
    }

    public static class SupportsJdbcDriverProxying
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return !(dialect instanceof DB2Dialect) && !(dialect instanceof DerbyDialect);
        }
    }

    public static class ForceLobAsLastValue
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.forceLobAsLastValue();
        }
    }

    public static class SupportDropConstraints
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.dropConstraints();
        }
    }

    public static class SupportWait
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsWait();
        }
    }

    public static class SupportNoWait
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsNoWait();
        }
    }

    public static class SupportSkipLocked
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsSkipLocked();
        }
    }

    public static class SupportPartitionBy
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsPartitionBy();
        }
    }

    public static class DoesNotSupportFollowOnLocking
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return !dialect.useFollowOnLocking(null, null);
        }
    }

    public static class SupportCatalogCreation
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.canCreateCatalog();
        }
    }

    public static class SupportSchemaCreation
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.canCreateSchema();
        }
    }

    public static class DoubleQuoteQuoting
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return '\"' == dialect.openQuote() && '\"' == dialect.closeQuote();
        }
    }

    public static class SupportsSkipLocked
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsSkipLocked();
        }
    }

    public static class SupportsLockTimeouts
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsLockTimeouts();
        }
    }

    public static class SupportsLobValueChangePropagation
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsLobValueChangePropagation();
        }
    }

    public static class SupportsExistsInSelectCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsExistsInSelect();
        }
    }

    public static class DoesRepeatableReadNotCauseReadersToBlockWritersCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return !dialect.doesRepeatableReadCauseReadersToBlockWriters();
        }
    }

    public static class DoesRepeatableReadCauseReadersToBlockWritersCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.doesRepeatableReadCauseReadersToBlockWriters();
        }
    }

    public static class DoesReadCommittedNotCauseWritersToBlockReadersCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return !dialect.doesReadCommittedCauseWritersToBlockReaders();
        }
    }

    public static class DoesReadCommittedCauseWritersToBlockReadersCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.doesReadCommittedCauseWritersToBlockReaders();
        }
    }

    public static class SupportsRowValueConstructorSyntaxCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect instanceof AbstractHANADialect || dialect instanceof CockroachDialect || dialect instanceof MySQLDialect || dialect instanceof PostgreSQLDialect;
        }
    }

    public static class HasSelfReferentialForeignKeyBugCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.hasSelfReferentialForeignKeyBug();
        }
    }

    public static class SupportsParametersInInsertSelectCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsParametersInInsertSelect();
        }
    }

    public static class SupportLimitAndOffsetCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.getLimitHandler().supportsLimit() && dialect.getLimitHandler().supportsLimitOffset();
        }
    }

    public static class SupportLimitCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.getLimitHandler().supportsLimit();
        }
    }

    public static class SupportSubqueryAsLeftHandSideInPredicate
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsSubselectAsInPredicateLHS();
        }
    }

    public static class SupportsUnboundedLobLocatorMaterializationCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern() && dialect.supportsUnboundedLobLocatorMaterialization();
        }
    }

    public static class SupportsCircularCascadeDeleteCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsCircularCascadeDeleteConstraints();
        }
    }

    public static class SupportsCascadeDeleteCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsCascadeDelete();
        }
    }

    public static class SupportsResultSetPositioningOnForwardOnlyCursorCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsResultSetPositionQueryMethodsOnForwardOnlyCursor();
        }
    }

    public static class SupportsColumnCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsColumnCheck();
        }
    }

    public static class SupportsIdentityColumns
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.getIdentityColumnSupport().supportsIdentityColumns();
        }
    }

    public static class UsesInputStreamToInsertBlob
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.useInputStreamToInsertBlob();
        }
    }

    public static class SupportsExpectedLobUsagePattern
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern();
        }
    }

    public static class SupportsSequences
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.getSequenceSupport().supportsSequences();
        }
    }
}

