/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class TestPathHelper {
    public static URL resolveRootUrl(Class knownClass) {
        String knownClassFileName = "/" + knownClass.getName().replace('.', File.separatorChar) + ".class";
        URL knownClassFileUrl = knownClass.getResource(knownClassFileName);
        String knownClassFileUrlString = knownClassFileUrl.toExternalForm();
        String rootUrlString = knownClassFileUrlString.substring(0, knownClassFileUrlString.lastIndexOf(File.separatorChar));
        String packageName = knownClass.getPackage().getName();
        for (String packageNamePart : packageName.split("\\.")) {
            rootUrlString = rootUrlString.substring(0, rootUrlString.lastIndexOf(File.separatorChar));
        }
        try {
            return new URL(rootUrlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not convert class base url as string to URL ref", e);
        }
    }

    public static File resolveRootDirectory(Class knownClass) {
        try {
            return new File(TestPathHelper.resolveRootUrl(knownClass).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not convert class root URL to a URI", e);
        }
    }

    public static File resolveClassFile(Class knownClass) {
        String knownClassFileName = "/" + knownClass.getName().replace('.', File.separatorChar) + ".class";
        URL knownClassFileUrl = knownClass.getResource(knownClassFileName);
        try {
            return new File(knownClassFileUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not convert class root URL to a URI", e);
        }
    }

    private TestPathHelper() {
    }
}

