/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.hamcrest;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hibernate.Hibernate;

public class InitializationCheckMatcher<T>
extends BaseMatcher<T> {
    public static final InitializationCheckMatcher INITIALIZED_MATCHER = new InitializationCheckMatcher();
    public static final InitializationCheckMatcher UNINITIALIZED_MATCHER = new InitializationCheckMatcher(false);
    private final boolean assertInitialized;

    public static <T> InitializationCheckMatcher<T> isInitialized() {
        return INITIALIZED_MATCHER;
    }

    public static <T> Matcher<T> isNotInitialized() {
        return UNINITIALIZED_MATCHER;
    }

    public InitializationCheckMatcher() {
        this(true);
    }

    public InitializationCheckMatcher(boolean assertInitialized) {
        this.assertInitialized = assertInitialized;
    }

    public boolean matches(Object item) {
        return this.assertInitialized == Hibernate.isInitialized((Object)item);
    }

    public void describeTo(Description description) {
        description.appendValue((Object)("Hibernate#isInitialized() returns " + this.assertInitialized));
    }
}

