/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.testing.jdbc.SQLStatementInspector;

public interface EntityManagerFactoryScope {
    public EntityManagerFactory getEntityManagerFactory();

    public void releaseEntityManagerFactory();

    public StatementInspector getStatementInspector();

    public <T extends StatementInspector> T getStatementInspector(Class<T> var1);

    public SQLStatementInspector getCollectingStatementInspector();

    public void inEntityManager(Consumer<EntityManager> var1);

    public void inTransaction(Consumer<EntityManager> var1);

    public void inTransaction(EntityManager var1, Consumer<EntityManager> var2);

    public <T> T fromEntityManager(Function<EntityManager, T> var1);

    public <T> T fromTransaction(Function<EntityManager, T> var1);

    public <T> T fromTransaction(EntityManager var1, Function<EntityManager, T> var2);

    default public Dialect getDialect() {
        return ((SessionFactoryImplementor)this.getEntityManagerFactory()).getJdbcServices().getDialect();
    }
}

