/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.WildcardPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.WildcardPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;
import org.hibernate.search.util.common.impl.Contracts;

class WildcardPredicateFieldMoreStepImpl
implements WildcardPredicateFieldMoreStep<WildcardPredicateFieldMoreStepImpl, WildcardPredicateOptionsStep<?>>,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState {
    private final CommonState commonState;
    private final List<WildcardPredicateBuilder> predicateBuilders = new ArrayList<WildcardPredicateBuilder>();
    private Float fieldSetBoost;

    WildcardPredicateFieldMoreStepImpl(CommonState commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        SearchPredicateBuilderFactory<?> predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.wildcard(absoluteFieldPath));
        }
    }

    @Override
    public WildcardPredicateFieldMoreStepImpl fields(String ... absoluteFieldPaths) {
        return new WildcardPredicateFieldMoreStepImpl(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public WildcardPredicateFieldMoreStepImpl boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public WildcardPredicateOptionsStep<?> matching(String wildcardPattern) {
        return this.commonState.matching(wildcardPattern);
    }

    @Override
    public void contributePredicates(Consumer<SearchPredicate> collector) {
        for (WildcardPredicateBuilder predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.build());
        }
    }

    static class CommonState
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState, WildcardPredicateFieldMoreStepImpl>
    implements WildcardPredicateOptionsStep<CommonState> {
        CommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        private WildcardPredicateOptionsStep<?> matching(String wildcardPattern) {
            Contracts.assertNotNull((Object)wildcardPattern, (String)"wildcardPattern");
            for (WildcardPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (WildcardPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.pattern(wildcardPattern);
                }
            }
            return this;
        }

        @Override
        protected CommonState thisAsS() {
            return this;
        }
    }
}

