/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.dsl.impl;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.DistanceToFieldProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.DocumentReferenceProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.EntityProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.EntityReferenceProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.FieldProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.ScoreProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactoryExtension;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactoryExtensionIfSupportedStep;
import org.hibernate.search.engine.search.projection.dsl.impl.CompositeProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.DistanceToFieldProjectionValueStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.DocumentReferenceProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.EntityProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.EntityReferenceProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.FieldProjectionValueStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.ScoreProjectionOptionsStepImpl;
import org.hibernate.search.engine.search.projection.dsl.impl.SearchProjectionFactoryExtensionStep;
import org.hibernate.search.engine.search.projection.dsl.spi.SearchProjectionDslContext;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.function.TriFunction;
import org.hibernate.search.util.common.impl.Contracts;

public class DefaultSearchProjectionFactory<R, E>
implements SearchProjectionFactory<R, E> {
    private final SearchProjectionDslContext<?> dslContext;

    public DefaultSearchProjectionFactory(SearchProjectionDslContext<?> dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public DocumentReferenceProjectionOptionsStep<?> documentReference() {
        return new DocumentReferenceProjectionOptionsStepImpl(this.dslContext);
    }

    @Override
    public <T> FieldProjectionValueStep<?, T> field(String absoluteFieldPath, Class<T> clazz, ValueConvert convert) {
        Contracts.assertNotNull(clazz, (String)"clazz");
        return new FieldProjectionValueStepImpl<T>(this.dslContext, absoluteFieldPath, clazz, convert);
    }

    @Override
    public FieldProjectionValueStep<?, Object> field(String absoluteFieldPath, ValueConvert convert) {
        return this.field(absoluteFieldPath, Object.class, convert);
    }

    @Override
    public EntityReferenceProjectionOptionsStep<?, R> entityReference() {
        return new EntityReferenceProjectionOptionsStepImpl(this.dslContext);
    }

    @Override
    public EntityProjectionOptionsStep<?, E> entity() {
        return new EntityProjectionOptionsStepImpl(this.dslContext);
    }

    @Override
    public ScoreProjectionOptionsStep<?> score() {
        return new ScoreProjectionOptionsStepImpl(this.dslContext);
    }

    @Override
    public DistanceToFieldProjectionValueStep<?, Double> distance(String absoluteFieldPath, GeoPoint center) {
        Contracts.assertNotNull((Object)center, (String)"center");
        return new DistanceToFieldProjectionValueStepImpl(this.dslContext, absoluteFieldPath, center);
    }

    @Override
    public <T> CompositeProjectionOptionsStep<?, T> composite(Function<List<?>, T> transformer, SearchProjection<?> ... projections) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNullNorEmpty((Object[])projections, (String)"projections");
        return new CompositeProjectionOptionsStepImpl<T>(this.dslContext, transformer, projections);
    }

    @Override
    public <P, T> CompositeProjectionOptionsStep<?, T> composite(Function<P, T> transformer, SearchProjection<P> projection) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection, (String)"projection");
        return new CompositeProjectionOptionsStepImpl<T>(this.dslContext, transformer, projection);
    }

    @Override
    public <P1, P2, T> CompositeProjectionOptionsStep<?, T> composite(BiFunction<P1, P2, T> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection1, (String)"projection1");
        Contracts.assertNotNull(projection2, (String)"projection2");
        return new CompositeProjectionOptionsStepImpl<T>(this.dslContext, transformer, projection1, projection2);
    }

    @Override
    public <P1, P2, P3, T> CompositeProjectionOptionsStep<?, T> composite(TriFunction<P1, P2, P3, T> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        Contracts.assertNotNull(transformer, (String)"transformer");
        Contracts.assertNotNull(projection1, (String)"projection1");
        Contracts.assertNotNull(projection2, (String)"projection2");
        Contracts.assertNotNull(projection3, (String)"projection3");
        return new CompositeProjectionOptionsStepImpl<T>(this.dslContext, transformer, projection1, projection2, projection3);
    }

    @Override
    public <T> T extension(SearchProjectionFactoryExtension<T, R, E> extension) {
        return DslExtensionState.returnIfSupported(extension, extension.extendOptional(this, this.dslContext));
    }

    @Override
    public <T> SearchProjectionFactoryExtensionIfSupportedStep<T, R, E> extension() {
        return new SearchProjectionFactoryExtensionStep(this, this.dslContext);
    }
}

