/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.dsl.spi;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.dsl.AggregationFinalStep;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.aggregation.dsl.impl.DefaultSearchAggregationFactory;
import org.hibernate.search.engine.search.aggregation.dsl.impl.SearchAggregationDslContextImpl;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilderFactory;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.impl.DefaultSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.impl.SearchPredicateDslContextImpl;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.engine.search.query.dsl.SearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.dsl.SearchQueryWhereStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.SortFinalStep;
import org.hibernate.search.engine.search.sort.dsl.impl.DefaultSearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.impl.SearchSortDslContextImpl;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;

public abstract class AbstractSearchQueryOptionsStep<S extends SearchQueryOptionsStep<S, H, LOS, SF, AF>, H, LOS, PDF extends SearchPredicateFactory, SF extends SearchSortFactory, AF extends SearchAggregationFactory, C>
implements SearchQueryWhereStep<S, H, LOS, PDF>,
SearchQueryOptionsStep<S, H, LOS, SF, AF> {
    private final IndexScope<C> indexScope;
    private final SearchQueryBuilder<H, C> searchQueryBuilder;
    private final LoadingContextBuilder<?, ?, LOS> loadingContextBuilder;

    public AbstractSearchQueryOptionsStep(IndexScope<C> indexScope, SearchQueryBuilder<H, C> searchQueryBuilder, LoadingContextBuilder<?, ?, LOS> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.searchQueryBuilder = searchQueryBuilder;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public S where(SearchPredicate predicate) {
        SearchPredicateBuilderFactory<C> factory = this.indexScope.searchPredicateBuilderFactory();
        this.contribute(factory, predicate);
        return this.thisAsS();
    }

    @Override
    public S where(Function<? super PDF, ? extends PredicateFinalStep> predicateContributor) {
        SearchPredicateBuilderFactory<C> builderFactory = this.indexScope.searchPredicateBuilderFactory();
        DefaultSearchPredicateFactory factory = new DefaultSearchPredicateFactory(SearchPredicateDslContextImpl.root(builderFactory));
        SearchPredicate predicate = predicateContributor.apply(this.extendPredicateFactory(factory)).toPredicate();
        this.contribute(builderFactory, predicate);
        return this.thisAsS();
    }

    @Override
    public S routing(String routingKey) {
        this.searchQueryBuilder.addRoutingKey(routingKey);
        return this.thisAsS();
    }

    @Override
    public S routing(Collection<String> routingKeys) {
        routingKeys.forEach(this.searchQueryBuilder::addRoutingKey);
        return this.thisAsS();
    }

    @Override
    public S truncateAfter(long timeout, TimeUnit timeUnit) {
        this.searchQueryBuilder.truncateAfter(timeout, timeUnit);
        return this.thisAsS();
    }

    @Override
    public S failAfter(long timeout, TimeUnit timeUnit) {
        this.searchQueryBuilder.failAfter(timeout, timeUnit);
        return this.thisAsS();
    }

    @Override
    public S totalHitCountThreshold(long totalHitCountThreshold) {
        this.searchQueryBuilder.totalHitCountThreshold(totalHitCountThreshold);
        return this.thisAsS();
    }

    @Override
    public S loading(Consumer<? super LOS> loadingOptionsContributor) {
        loadingOptionsContributor.accept(this.loadingContextBuilder.toAPI());
        return this.thisAsS();
    }

    @Override
    public S sort(SearchSort sort) {
        SearchSortBuilderFactory<C> factory = this.indexScope.searchSortBuilderFactory();
        this.contribute(factory, sort);
        return this.thisAsS();
    }

    @Override
    public S sort(Function<? super SF, ? extends SortFinalStep> sortContributor) {
        SearchSortBuilderFactory<C> builderFactory = this.indexScope.searchSortBuilderFactory();
        SearchPredicateBuilderFactory<C> predicateBuilderFactory = this.indexScope.searchPredicateBuilderFactory();
        DefaultSearchPredicateFactory predicateFactory = new DefaultSearchPredicateFactory(SearchPredicateDslContextImpl.root(predicateBuilderFactory));
        DefaultSearchSortFactory factory = new DefaultSearchSortFactory(SearchSortDslContextImpl.root(builderFactory, predicateFactory));
        SearchSort sort = sortContributor.apply(this.extendSortFactory(factory)).toSort();
        this.contribute(builderFactory, sort);
        return this.thisAsS();
    }

    @Override
    public <A> S aggregation(AggregationKey<A> key, SearchAggregation<A> aggregation) {
        SearchAggregationBuilderFactory<C> builderFactory = this.indexScope.searchAggregationFactory();
        this.contribute(builderFactory, key, aggregation);
        return this.thisAsS();
    }

    @Override
    public <A> S aggregation(AggregationKey<A> key, Function<? super AF, ? extends AggregationFinalStep<A>> aggregationContributor) {
        SearchAggregationBuilderFactory<C> builderFactory = this.indexScope.searchAggregationFactory();
        SearchPredicateBuilderFactory<C> predicateBuilderFactory = this.indexScope.searchPredicateBuilderFactory();
        DefaultSearchPredicateFactory predicateFactory = new DefaultSearchPredicateFactory(SearchPredicateDslContextImpl.root(predicateBuilderFactory));
        AF factory = this.extendAggregationFactory(new DefaultSearchAggregationFactory(SearchAggregationDslContextImpl.root(builderFactory, predicateFactory)));
        SearchAggregation<A> aggregation = aggregationContributor.apply(factory).toAggregation();
        this.contribute(builderFactory, key, aggregation);
        return this.thisAsS();
    }

    @Override
    public SearchQuery<H> toQuery() {
        return this.searchQueryBuilder.build();
    }

    @Override
    public SearchResult<H> fetchAll() {
        return this.toQuery().fetchAll();
    }

    @Override
    public SearchResult<H> fetch(Integer limit) {
        return this.toQuery().fetch(limit);
    }

    @Override
    public SearchResult<H> fetch(Integer offset, Integer limit) {
        return this.toQuery().fetch(offset, limit);
    }

    @Override
    public List<H> fetchAllHits() {
        return this.toQuery().fetchAllHits();
    }

    @Override
    public List<H> fetchHits(Integer limit) {
        return this.toQuery().fetchHits(limit);
    }

    @Override
    public List<H> fetchHits(Integer offset, Integer limit) {
        return this.toQuery().fetchHits(offset, limit);
    }

    @Override
    public Optional<H> fetchSingleHit() {
        return this.toQuery().fetchSingleHit();
    }

    @Override
    public long fetchTotalHitCount() {
        return this.toQuery().fetchTotalHitCount();
    }

    @Override
    public SearchScroll<H> scroll(int chunkSize) {
        return this.toQuery().scroll(chunkSize);
    }

    private void contribute(SearchPredicateBuilderFactory<? super C> factory, SearchPredicate predicate) {
        factory.contribute(this.searchQueryBuilder.toQueryElementCollector(), predicate);
    }

    private void contribute(SearchSortBuilderFactory<? super C> factory, SearchSort sort) {
        factory.contribute(this.searchQueryBuilder.toQueryElementCollector(), sort);
    }

    private <A> void contribute(SearchAggregationBuilderFactory<? super C> factory, AggregationKey<A> aggregationKey, SearchAggregation<A> aggregation) {
        factory.contribute(this.searchQueryBuilder.toQueryElementCollector(), aggregationKey, aggregation);
    }

    protected abstract S thisAsS();

    protected abstract PDF extendPredicateFactory(SearchPredicateFactory var1);

    protected abstract SF extendSortFactory(SearchSortFactory var1);

    protected abstract AF extendAggregationFactory(SearchAggregationFactory var1);
}

