/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SimpleSearchResultTotal
implements SearchResultTotal {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final long totalHitCount;
    private final boolean isExact;

    public static SimpleSearchResultTotal exact(long totalHitCount) {
        return new SimpleSearchResultTotal(totalHitCount, true);
    }

    public static SimpleSearchResultTotal lowerBound(long totalHitCount) {
        return new SimpleSearchResultTotal(totalHitCount, false);
    }

    private SimpleSearchResultTotal(long totalHitCount, boolean isExact) {
        this.totalHitCount = totalHitCount;
        this.isExact = isExact;
    }

    @Override
    public boolean isHitCountExact() {
        return this.isExact;
    }

    @Override
    public boolean isHitCountLowerBound() {
        return !this.isExact;
    }

    @Override
    public long hitCount() {
        if (!this.isExact) {
            throw log.notExactTotalHitCount();
        }
        return this.totalHitCount;
    }

    @Override
    public long hitCountLowerBound() {
        return this.totalHitCount;
    }

    public String toString() {
        return "SimpleSearchResultTotal{totalHitCount=" + this.totalHitCount + ", isExact=" + this.isExact + '}';
    }
}

