/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spatial;

import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.ImmutableGeoBoundingBox;

public interface GeoBoundingBox {
    public GeoPoint topLeft();

    @Deprecated
    default public GeoPoint getTopLeft() {
        return this.topLeft();
    }

    public GeoPoint bottomRight();

    @Deprecated
    default public GeoPoint getBottomRight() {
        return this.bottomRight();
    }

    public static GeoBoundingBox of(GeoPoint topLeft, GeoPoint bottomRight) {
        return new ImmutableGeoBoundingBox(topLeft, bottomRight);
    }

    public static GeoBoundingBox of(double topLeftLatitude, double topLeftLongitude, double bottomRightLatitude, double bottomRightLongitude) {
        return new ImmutableGeoBoundingBox(GeoPoint.of(topLeftLatitude, topLeftLongitude), GeoPoint.of(bottomRightLatitude, bottomRightLongitude));
    }
}

