/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.util.common.impl.Contracts;

final class InstanceBeanReference<T>
implements BeanReference<T> {
    private final T instance;

    InstanceBeanReference(T instance) {
        Contracts.assertNotNull(instance, (String)"instance");
        this.instance = instance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[instance=" + this.instance + "]";
    }

    @Override
    public BeanHolder<T> resolve(BeanResolver beanResolver) {
        return BeanHolder.of(this.instance);
    }

    @Override
    public <U> BeanReference<? extends U> asSubTypeOf(Class<U> expectedType) {
        expectedType.cast(this.instance);
        return this;
    }
}

