/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm;

import java.lang.invoke.MethodHandles;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.query.Query;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchQueryAdapter;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.impl.LazyInitSearchSession;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class Search {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private Search() {
    }

    public static SearchSession session(Session session) {
        SessionImplementor sessionImpl;
        try {
            sessionImpl = (SessionImplementor)session.unwrap(SessionImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionAccessError(e);
        }
        return Search.createSearchSession(sessionImpl);
    }

    public static SearchSession session(EntityManager entityManager) {
        SessionImplementor sessionImpl;
        try {
            sessionImpl = (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionAccessError(e);
        }
        return Search.createSearchSession(sessionImpl);
    }

    @Deprecated
    public static SearchSession getSearchSession(Session session) {
        return Search.session(session);
    }

    @Deprecated
    public static SearchSession getSearchSession(EntityManager entityManager) {
        return Search.session(entityManager);
    }

    public static <H> TypedQuery<H> toJpaQuery(SearchQuery<H> searchQuery) {
        return HibernateOrmSearchQueryAdapter.create(searchQuery);
    }

    public static <H> Query<H> toOrmQuery(SearchQuery<H> searchQuery) {
        return HibernateOrmSearchQueryAdapter.create(searchQuery);
    }

    private static SearchSession createSearchSession(SessionImplementor sessionImplementor) {
        return new LazyInitSearchSession(sessionImplementor);
    }
}

