/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderFactory;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmByIdEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmCriteriaEntityLoader;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionIndexedTypeContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.spi.IdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

class HibernateOrmIndexedTypeContext<E>
extends AbstractHibernateOrmTypeContext<E>
implements HibernateOrmSessionIndexedTypeContext<E>,
HibernateOrmScopeIndexedTypeContext<E> {
    private final String indexName;
    private final boolean documentIdIsEntityId;
    private final EntityLoaderFactory loaderFactory;
    private final IdentifierMapping identifierMapping;

    private HibernateOrmIndexedTypeContext(Builder<E> builder, SessionFactoryImplementor sessionFactory) {
        super(((Builder)builder).javaClass);
        this.indexName = ((Builder)builder).indexName;
        EntityTypeDescriptor indexTypeModel = sessionFactory.getMetamodel().entity(this.getJavaClass());
        SingularAttribute documentIdSourceAttribute = indexTypeModel.getSingularAttribute(((Builder)builder).documentIdSourcePropertyName);
        if (documentIdSourceAttribute.isId()) {
            this.documentIdIsEntityId = true;
            this.loaderFactory = HibernateOrmByIdEntityLoader.factory(sessionFactory, this.getJavaClass());
        } else {
            this.documentIdIsEntityId = false;
            this.loaderFactory = HibernateOrmCriteriaEntityLoader.factory(this.getJavaClass(), documentIdSourceAttribute, ((Builder)builder).documentIdSourcePropertyHandle);
        }
        this.identifierMapping = ((Builder)builder).identifierMapping;
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public Object toWorkPlanProvidedId(Object entityId) {
        if (this.documentIdIsEntityId) {
            return entityId;
        }
        return null;
    }

    @Override
    public IdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public EntityLoaderFactory getLoaderFactory() {
        return this.loaderFactory;
    }

    static class Builder<E>
    implements PojoIndexedTypeExtendedMappingCollector {
        private final Class<E> javaClass;
        private final String indexName;
        private String documentIdSourcePropertyName;
        private ValueReadHandle<?> documentIdSourcePropertyHandle;
        private IdentifierMapping identifierMapping;

        Builder(Class<E> javaClass, String indexName) {
            this.javaClass = javaClass;
            this.indexName = indexName;
        }

        public void documentIdSourceProperty(PojoPropertyModel<?> documentIdSourceProperty) {
            this.documentIdSourcePropertyName = documentIdSourceProperty.getName();
            this.documentIdSourcePropertyHandle = documentIdSourceProperty.getHandle();
        }

        public void identifierMapping(IdentifierMapping identifierMapping) {
            this.identifierMapping = identifierMapping;
        }

        public HibernateOrmIndexedTypeContext<E> build(SessionFactoryImplementor sessionFactory) {
            return new HibernateOrmIndexedTypeContext(this, sessionFactory);
        }
    }
}

