/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContext;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.Service;

public final class HibernateSearchContextService
implements Service,
AutoCloseable,
HibernateOrmListenerContextProvider,
HibernateOrmSearchSessionContextProvider {
    private volatile SearchIntegration integration;
    private volatile HibernateOrmMapping mapping;

    public static HibernateSearchContextService get(SessionFactoryImplementor sessionFactory) {
        return (HibernateSearchContextService)sessionFactory.getServiceRegistry().getService(HibernateSearchContextService.class);
    }

    @Override
    public void close() {
        if (this.integration != null) {
            this.integration.close();
        }
    }

    public void initialize(SearchIntegration integration, HibernateOrmMapping mapping) {
        this.integration = integration;
        this.mapping = mapping;
    }

    @Override
    public PojoWorkPlan getCurrentWorkPlan(SessionImplementor session) {
        return this.getMapping().getSearchSession(session).getCurrentWorkPlan();
    }

    @Override
    public <E> HibernateOrmListenerTypeContext getTypeContext(Class<E> type) {
        return this.getMapping().getTypeContext(type);
    }

    @Override
    public HibernateOrmSearchSession getSearchSession(SessionImplementor sessionImplementor) {
        return this.getMapping().getSearchSession(sessionImplementor);
    }

    private HibernateOrmMapping getMapping() {
        if (this.mapping != null) {
            return this.mapping;
        }
        throw ((Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup())).hibernateSearchNotInitialized();
    }
}

