/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.transaction.TransactionManager;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.query.Query;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IdentifierConsumerDocumentProducer
implements Runnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ProducerConsumerQueue<List<Serializable>> source;
    private final SessionFactory sessionFactory;
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final CacheMode cacheMode;
    private final Class<?> type;
    private final MassIndexingMonitor monitor;
    private final String idName;
    private final CountDownLatch producerEndSignal;
    private final Integer transactionTimeout;
    private final String tenantId;
    private final TransactionManager transactionManager;

    IdentifierConsumerDocumentProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, MassIndexingMonitor monitor, SessionFactory sessionFactory, HibernateOrmMassIndexingMappingContext mappingContext, CountDownLatch producerEndSignal, CacheMode cacheMode, Class<?> indexedType, String idName, Integer transactionTimeout, String tenantId) {
        this.source = fromIdentifierListToEntities;
        this.sessionFactory = sessionFactory;
        this.mappingContext = mappingContext;
        this.cacheMode = cacheMode;
        this.type = indexedType;
        this.monitor = monitor;
        this.idName = idName;
        this.producerEndSignal = producerEndSignal;
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.transactionManager = ((JtaPlatform)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
        log.trace("created");
    }

    @Override
    public void run() {
        log.trace("started");
        SessionImplementor session = (SessionImplementor)this.sessionFactory.withOptions().tenantIdentifier(this.tenantId).openSession();
        session.setHibernateFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        try {
            this.loadAllFromQueue(session);
        }
        catch (Exception exception) {
            String logMessage = log.massIndexerExceptionWhileTransformingIds();
            throw new RuntimeException(logMessage, exception);
        }
        finally {
            this.producerEndSignal.countDown();
            session.close();
        }
        log.trace("finished");
    }

    private void loadAllFromQueue(SessionImplementor session) throws Exception {
        PojoSessionWorkExecutor workExecutor = this.mappingContext.createSessionWorkExecutor(session, DocumentCommitStrategy.NONE);
        try {
            List<Serializable> idList;
            do {
                if ((idList = this.source.take()) == null) continue;
                log.tracef("received list of ids %s", idList);
                this.loadList(idList, session, workExecutor);
            } while (idList != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList(List<Serializable> listIds, SessionImplementor session, PojoSessionWorkExecutor workExecutor) throws Exception {
        try {
            this.beginTransaction((Session)session);
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.type);
            Root root = criteria.from(this.type);
            criteria.where((Expression)root.get(this.idName).in(listIds));
            Query query = session.createQuery(criteria).setCacheMode(this.cacheMode).setLockMode(LockModeType.NONE).setCacheable(false).setHibernateFlushMode(FlushMode.MANUAL).setFetchSize(listIds.size()).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            this.indexAllQueue(workExecutor, query.getResultList());
            session.clear();
        }
        finally {
            this.rollbackTransaction(session);
        }
    }

    private void beginTransaction(Session session) throws Exception {
        if (this.transactionManager != null) {
            if (this.transactionTimeout != null) {
                this.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
            }
            this.transactionManager.begin();
        } else {
            session.beginTransaction();
        }
    }

    private void rollbackTransaction(SessionImplementor session) {
        try {
            if (this.transactionManager != null) {
                this.transactionManager.rollback();
            } else {
                session.accessTransaction().rollback();
            }
        }
        catch (Exception e) {
            log.errorRollingBackTransaction(e.getMessage(), e);
        }
    }

    private void indexAllQueue(PojoSessionWorkExecutor workExecutor, List<?> entities) throws InterruptedException {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        this.monitor.entitiesLoaded(entities.size());
        CompletableFuture[] futures = new CompletableFuture[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            Object entity = entities.get(i);
            futures[i] = this.index(workExecutor, entity);
            futures[i].exceptionally(exception -> {
                this.handleException(entity, (Throwable)exception);
                return null;
            });
        }
        ((CompletableFuture)CompletableFuture.allOf(futures).exceptionally(exception -> null)).join();
        this.monitor.documentsAdded(entities.size());
    }

    private CompletableFuture<?> index(PojoSessionWorkExecutor workExecutor, Object entity) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        CompletableFuture future = Futures.create(() -> workExecutor.add(entity).exceptionally(exception -> {
            this.handleException(entity, (Throwable)exception);
            return null;
        }));
        this.monitor.documentsBuilt(1L);
        return future;
    }

    private void handleException(Object entity, Throwable e) {
        String errorMsg = log.massIndexerUnableToIndexInstance(entity.getClass().getName(), entity.toString());
        throw new RuntimeException(errorMsg, e);
    }
}

