/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmPropertyModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoCommonsAnnotationsHelper;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.JavaClassPojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmRawTypeModel<T>
implements PojoRawTypeModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmBootstrapIntrospector introspector;
    private final XClass xClass;
    private final Class<T> clazz;
    private final HibernateOrmBasicTypeMetadata ormTypeMetadata;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private final PojoCaster<T> caster;
    private final Map<String, HibernateOrmPropertyModel<?>> propertyModelCache = new HashMap();
    private List<PojoPropertyModel<?>> declaredProperties;
    private Map<String, XProperty> declaredFieldAccessXPropertiesByName;
    private Map<String, XProperty> declaredMethodAccessXPropertiesByName;

    HibernateOrmRawTypeModel(HibernateOrmBootstrapIntrospector introspector, Class<T> clazz, HibernateOrmBasicTypeMetadata ormTypeMetadata, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        this.introspector = introspector;
        this.xClass = introspector.toXClass(clazz);
        this.clazz = clazz;
        this.ormTypeMetadata = ormTypeMetadata;
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
        this.caster = new JavaClassPojoCaster(clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HibernateOrmRawTypeModel that = (HibernateOrmRawTypeModel)o;
        return Objects.equals((Object)this.introspector, (Object)that.introspector) && Objects.equals(this.clazz, that.clazz);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.introspector, this.clazz});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.clazz.getName() + "]";
    }

    public String getName() {
        return this.clazz.getName();
    }

    public boolean isAbstract() {
        return this.xClass.isAbstract();
    }

    public boolean isSubTypeOf(MappableTypeModel other) {
        return other instanceof HibernateOrmRawTypeModel && ((HibernateOrmRawTypeModel)other).xClass.isAssignableFrom(this.xClass);
    }

    public PojoRawTypeModel<? super T> getRawType() {
        return this;
    }

    public boolean isSubTypeOf(Class<?> superClassCandidate) {
        XClass superClassCandidateXClass = this.introspector.toXClass(superClassCandidate);
        return superClassCandidateXClass.isAssignableFrom(this.xClass);
    }

    public Stream<HibernateOrmRawTypeModel<? super T>> getAscendingSuperTypes() {
        return this.introspector.getAscendingSuperTypes(this.xClass);
    }

    public Stream<HibernateOrmRawTypeModel<? super T>> getDescendingSuperTypes() {
        return this.introspector.getDescendingSuperTypes(this.xClass);
    }

    public <A extends Annotation> Optional<A> getAnnotationByType(Class<A> annotationType) {
        return this.introspector.getAnnotationByType((XAnnotatedElement)this.xClass, annotationType);
    }

    public <A extends Annotation> Stream<A> getAnnotationsByType(Class<A> annotationType) {
        return this.introspector.getAnnotationsByType((XAnnotatedElement)this.xClass, annotationType);
    }

    public Stream<? extends Annotation> getAnnotationsByMetaAnnotationType(Class<? extends Annotation> metaAnnotationType) {
        return this.introspector.getAnnotationsByMetaAnnotationType((XAnnotatedElement)this.xClass, metaAnnotationType);
    }

    public final PojoPropertyModel<?> getProperty(String propertyName) {
        HibernateOrmPropertyModel<?> propertyModel = this.getPropertyOrNull(propertyName);
        if (propertyModel == null) {
            throw log.cannotFindReadableProperty(this, propertyName);
        }
        return propertyModel;
    }

    public Stream<PojoPropertyModel<?>> getDeclaredProperties() {
        if (this.declaredProperties == null) {
            this.declaredProperties = Stream.concat(this.getDeclaredFieldAccessXPropertiesByName().keySet().stream(), this.getDeclaredMethodAccessXPropertiesByName().keySet().stream()).distinct().map(this::getPropertyOrNull).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.declaredProperties.stream();
    }

    public PojoCaster<T> getCaster() {
        return this.caster;
    }

    public final Class<T> getJavaClass() {
        return this.clazz;
    }

    GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> getRawTypeDeclaringContext() {
        return this.rawTypeDeclaringContext;
    }

    private Map<String, XProperty> getDeclaredFieldAccessXPropertiesByName() {
        if (this.declaredFieldAccessXPropertiesByName == null) {
            this.declaredFieldAccessXPropertiesByName = this.introspector.getDeclaredFieldAccessXPropertiesByName(this.xClass);
        }
        return this.declaredFieldAccessXPropertiesByName;
    }

    private Map<String, XProperty> getDeclaredMethodAccessXPropertiesByName() {
        if (this.declaredMethodAccessXPropertiesByName == null) {
            this.declaredMethodAccessXPropertiesByName = this.introspector.getDeclaredMethodAccessXPropertiesByName(this.xClass);
        }
        return this.declaredMethodAccessXPropertiesByName;
    }

    private HibernateOrmPropertyModel<?> getPropertyOrNull(String propertyName) {
        return this.propertyModelCache.computeIfAbsent(propertyName, this::createPropertyModel);
    }

    private HibernateOrmPropertyModel<?> createPropertyModel(String propertyName) {
        HibernateOrmBasicPropertyMetadata ormPropertyMetadata;
        Member member;
        XProperty fieldAccessXProperty;
        ArrayList<XProperty> declaredXProperties = new ArrayList<XProperty>(2);
        XProperty methodAccessXProperty = this.getDeclaredMethodAccessXPropertiesByName().get(propertyName);
        if (methodAccessXProperty != null) {
            declaredXProperties.add(methodAccessXProperty);
        }
        if ((fieldAccessXProperty = this.getDeclaredFieldAccessXPropertiesByName().get(propertyName)) != null) {
            declaredXProperties.add(fieldAccessXProperty);
        }
        if ((member = this.findPropertyMember(propertyName, methodAccessXProperty, fieldAccessXProperty, ormPropertyMetadata = this.ormTypeMetadata == null ? null : this.ormTypeMetadata.getPropertyMetadataOrNull(propertyName))) == null) {
            return null;
        }
        return new HibernateOrmPropertyModel(this.introspector, this, propertyName, declaredXProperties, ormPropertyMetadata, member);
    }

    private Member findPropertyMember(String propertyName, XProperty methodAccessXProperty, XProperty fieldAccessXProperty, HibernateOrmBasicPropertyMetadata propertyMetadataFromHibernateOrmMetamodel) {
        if (propertyMetadataFromHibernateOrmMetamodel != null) {
            Member memberFromHibernateOrmMetamodel = propertyMetadataFromHibernateOrmMetamodel.getMember();
            if (memberFromHibernateOrmMetamodel instanceof Method) {
                return methodAccessXProperty == null ? memberFromHibernateOrmMetamodel : PojoCommonsAnnotationsHelper.getUnderlyingMember((XProperty)methodAccessXProperty);
            }
            if (memberFromHibernateOrmMetamodel instanceof Field) {
                return fieldAccessXProperty == null ? memberFromHibernateOrmMetamodel : PojoCommonsAnnotationsHelper.getUnderlyingMember((XProperty)fieldAccessXProperty);
            }
            return this.getPropertyMemberFromParentTypes(propertyName);
        }
        if (methodAccessXProperty != null) {
            return PojoCommonsAnnotationsHelper.getUnderlyingMember((XProperty)methodAccessXProperty);
        }
        if (fieldAccessXProperty != null) {
            return PojoCommonsAnnotationsHelper.getUnderlyingMember((XProperty)fieldAccessXProperty);
        }
        return this.getPropertyMemberFromParentTypes(propertyName);
    }

    private Member getPropertyMemberFromParentTypes(String propertyName) {
        return this.getAscendingSuperTypes().skip(1L).map(type -> type.getPropertyOrNull(propertyName)).filter(Objects::nonNull).findFirst().map(HibernateOrmPropertyModel::getMember).orElse(null);
    }
}

