/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.io.Serializable;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoadingCacheLookupStrategyImplementor;

class PersistenceContextLookupStrategy<E>
implements EntityLoadingCacheLookupStrategyImplementor<E> {
    private final EntityPersister persister;
    private final SessionImplementor session;
    private final PersistenceContext persistenceContext;

    static <E> EntityLoadingCacheLookupStrategyImplementor<E> create(Class<E> commonEntitySuperType, SessionImplementor session) {
        MetamodelImplementor metamodelImplementor = session.getSessionFactory().getMetamodel();
        EntityPersister persister = metamodelImplementor.entityPersister(commonEntitySuperType);
        return new PersistenceContextLookupStrategy<E>(persister, session);
    }

    private PersistenceContextLookupStrategy(EntityPersister persister, SessionImplementor session) {
        this.persister = persister;
        this.session = session;
        this.persistenceContext = session.getPersistenceContext();
    }

    @Override
    public E lookup(Object entityId) {
        EntityKey entityKey = this.session.generateEntityKey((Serializable)entityId, this.persister);
        Object loadedEntityOrNull = this.persistenceContext.getEntity(entityKey);
        return (E)loadedEntityOrNull;
    }
}

