/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class HibernateOrmRawTypeIdentifierResolver {
    private final Map<Class<?>, PojoRawTypeIdentifier<?>> byJavaClass;
    private final Map<String, PojoRawTypeIdentifier<?>> byHibernateOrmEntityName;
    private final Map<String, PojoRawTypeIdentifier<?>> byJpaOrHibernateOrmEntityName;

    static <T> PojoRawTypeIdentifier<T> createClassTypeIdentifier(Class<T> javaClass) {
        return PojoRawTypeIdentifier.of(javaClass);
    }

    static PojoRawTypeIdentifier<Map> createDynamicMapTypeIdentifier(String name) {
        return PojoRawTypeIdentifier.of(Map.class, (String)name);
    }

    private HibernateOrmRawTypeIdentifierResolver(Builder builder) {
        this.byJavaClass = Collections.unmodifiableMap(builder.byJavaClass);
        this.byHibernateOrmEntityName = Collections.unmodifiableMap(builder.byHibernateOrmEntityName);
        this.byJpaOrHibernateOrmEntityName = Collections.unmodifiableMap(builder.byJpaOrHibernateOrmEntityName);
    }

    public <T> PojoRawTypeIdentifier<T> resolveByJavaClass(Class<T> javaClass) {
        PojoRawTypeIdentifier<?> result = this.byJavaClass.get(javaClass);
        if (result != null) {
            return result;
        }
        return HibernateOrmRawTypeIdentifierResolver.createClassTypeIdentifier(javaClass);
    }

    public PojoRawTypeIdentifier<?> resolveByHibernateOrmEntityName(String entityName) {
        return this.byHibernateOrmEntityName.get(entityName);
    }

    public PojoRawTypeIdentifier<?> resolveByJpaOrHibernateOrmEntityName(String entityName) {
        return this.byJpaOrHibernateOrmEntityName.get(entityName);
    }

    public Set<String> allKnownHibernateOrmEntityNames() {
        return this.byHibernateOrmEntityName.keySet();
    }

    public Set<String> allKnownJpaOrHibernateOrmEntityNames() {
        return this.byJpaOrHibernateOrmEntityName.keySet();
    }

    static class Builder {
        private final Map<Class<?>, PojoRawTypeIdentifier<?>> byJavaClass = new LinkedHashMap();
        private final Map<String, PojoRawTypeIdentifier<?>> byJpaEntityName = new LinkedHashMap();
        private final Map<String, PojoRawTypeIdentifier<?>> byHibernateOrmEntityName = new LinkedHashMap();
        private final Map<String, PojoRawTypeIdentifier<?>> byJpaOrHibernateOrmEntityName = new LinkedHashMap();

        Builder() {
        }

        <T> void addClassEntityType(Class<T> javaClass, String jpaEntityName, String hibernateOrmEntityName) {
            PojoRawTypeIdentifier<T> typeIdentifier = HibernateOrmRawTypeIdentifierResolver.createClassTypeIdentifier(javaClass);
            this.byJavaClass.put(javaClass, typeIdentifier);
            this.addByName(typeIdentifier, jpaEntityName, hibernateOrmEntityName);
        }

        void addDynamicMapEntityType(String jpaEntityName, String hibernateOrmEntityName) {
            PojoRawTypeIdentifier<Map> typeIdentifier = HibernateOrmRawTypeIdentifierResolver.createDynamicMapTypeIdentifier(hibernateOrmEntityName);
            this.addByName(typeIdentifier, jpaEntityName, hibernateOrmEntityName);
        }

        private <T> void addByName(PojoRawTypeIdentifier<T> typeIdentifier, String jpaEntityName, String hibernateOrmEntityName) {
            this.byJpaEntityName.put(jpaEntityName, typeIdentifier);
            this.byHibernateOrmEntityName.put(hibernateOrmEntityName, typeIdentifier);
            this.byJpaOrHibernateOrmEntityName.put(jpaEntityName, typeIdentifier);
            this.byJpaOrHibernateOrmEntityName.putIfAbsent(hibernateOrmEntityName, typeIdentifier);
        }

        HibernateOrmRawTypeIdentifierResolver build() {
            return new HibernateOrmRawTypeIdentifierResolver(this);
        }
    }
}

