/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.api.export.Exporter;

public abstract class ExporterTask {
    protected HibernateToolTask parent;
    Properties properties;
    private Path templatePath;

    public ExporterTask(HibernateToolTask parent) {
        this.parent = parent;
        this.properties = new Properties();
    }

    public void execute() {
        Exporter exporter = this.configureExporter(this.createExporter());
        exporter.start();
    }

    protected abstract Exporter createExporter();

    public File getDestdir() {
        File destdir = (File)this.properties.get("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder");
        if (destdir == null) {
            return this.parent.getDestDir();
        }
        return destdir;
    }

    public void setDestdir(File destdir) {
        this.properties.put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", destdir);
    }

    public void setTemplatePath(Path path) {
        this.templatePath = path;
    }

    public void setTemplatePrefix(String s) {
    }

    public void validateParameters() {
        if (this.getDestdir() == null) {
            throw new BuildException("destdir must be set, either locally or on <hibernatetool>");
        }
    }

    public void addConfiguredPropertySet(PropertySet ps) {
        this.properties.putAll((Map<?, ?>)ps.getProperties());
    }

    public void addConfiguredProperty(Environment.Variable property) {
        this.properties.put(property.getKey(), property.getValue());
    }

    protected Path getTemplatePath() {
        if (this.templatePath == null) {
            return this.parent.getTemplatePath();
        }
        return this.templatePath;
    }

    abstract String getName();

    protected Exporter configureExporter(Exporter exporter) {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)this.parent.getProperties());
        prop.putAll((Map<?, ?>)this.properties);
        exporter.getProperties().putAll((Map<?, ?>)prop);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", this.parent.getMetadataDescriptor());
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", this.getDestdir());
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplatePath", this.getTemplatePath().list());
        return exporter;
    }
}

