/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant.fresh;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.api.metadata.MetadataDescriptorFactory;

public class MetadataTask {
    String persistenceUnit = null;
    File propertyFile = null;
    File configFile = null;
    List<FileSet> fileSets = new ArrayList<FileSet>();
    Type type = Type.NATIVE;

    public void setPersistenceUnit(String pU) {
        this.persistenceUnit = pU;
    }

    public void setPropertyFile(File file) {
        this.propertyFile = file;
    }

    public void setConfigFile(File file) {
        this.configFile = file;
    }

    public void setType(String type) {
        this.type = Type.valueOf(type.toUpperCase());
    }

    public void addConfiguredFileSet(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public MetadataDescriptor createMetadataDescriptor() {
        switch (this.type.ordinal()) {
            case 2: {
                return MetadataDescriptorFactory.createNativeDescriptor((File)this.configFile, (File[])this.getFiles(), (Properties)this.getProperties());
            }
            case 1: {
                return MetadataDescriptorFactory.createJpaDescriptor((String)this.persistenceUnit, (Properties)this.getProperties());
            }
        }
        return null;
    }

    private File[] getFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (FileSet fileSet : this.fileSets) {
            DirectoryScanner scanner = fileSet.getDirectoryScanner();
            for (String fileName : scanner.getIncludedFiles()) {
                File file = new File(fileName);
                if (!file.isFile()) {
                    file = new File(scanner.getBasedir(), fileName);
                }
                result.add(file);
            }
        }
        return result.toArray(new File[result.size()]);
    }

    private Properties getProperties() {
        Properties result = new Properties();
        if (this.propertyFile != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.propertyFile);
                result.load(is);
            }
            catch (FileNotFoundException e) {
                throw new BuildException(String.valueOf(this.propertyFile) + " not found.", (Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException("Problem while loading " + String.valueOf(this.propertyFile), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    static enum Type {
        JDBC,
        JPA,
        NATIVE;

    }
}

