/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.maven;

import java.io.File;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.maven.AbstractGenerationMojo;

@Mojo(name="hbm2java", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateJavaMojo
extends AbstractGenerationMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/")
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean ejb3;
    @Parameter(defaultValue="false")
    private boolean jdk5;
    @Parameter
    private String templatePath;

    @Override
    protected void executeExporter(MetadataDescriptor metadataDescriptor) {
        Exporter pojoExporter = ExporterFactory.createExporter((ExporterType)ExporterType.JAVA);
        pojoExporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", metadataDescriptor);
        pojoExporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", this.outputDirectory);
        if (this.templatePath != null) {
            this.getLog().info((CharSequence)("Setting template path to: " + this.templatePath));
            pojoExporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplatePath", new String[]{this.templatePath});
        }
        pojoExporter.getProperties().setProperty("ejb3", String.valueOf(this.ejb3));
        pojoExporter.getProperties().setProperty("jdk5", String.valueOf(this.jdk5));
        this.getLog().info((CharSequence)("Starting POJO export to directory: " + this.outputDirectory + "..."));
        pojoExporter.start();
    }
}

