/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.tool.internal.export.common.DefaultValueVisitor;
import org.hibernate.tool.internal.export.java.Cfg2JavaTool;
import org.hibernate.tool.internal.export.java.ImportContext;
import org.hibernate.tool.internal.export.java.ImportContextImpl;
import org.hibernate.tool.internal.export.java.MetaAttributeConstants;
import org.hibernate.tool.internal.export.java.MetaAttributeHelper;
import org.hibernate.tool.internal.export.java.POJOClass;
import org.hibernate.tool.internal.util.NameConverter;

public abstract class BasicPOJOClass
implements POJOClass,
MetaAttributeConstants {
    protected ImportContext importContext;
    protected MetaAttributable meta;
    protected final Cfg2JavaTool c2j;
    static java.util.Map<String, DefaultInitializor> defaultInitializors = new HashMap<String, DefaultInitializor>();

    public BasicPOJOClass(MetaAttributable ma, Cfg2JavaTool c2j) {
        this.meta = ma;
        this.c2j = c2j;
        if (this.meta == null) {
            throw new IllegalArgumentException("class Argument must be not null");
        }
        if (this.c2j == null) {
            throw new IllegalArgumentException("c2j must be not null");
        }
    }

    protected void init() {
        this.importContext = new ImportContextImpl(this.getPackageName());
        MetaAttribute metaAttribute = this.meta.getMetaAttribute("extra-import");
        if (metaAttribute != null) {
            for (String element : metaAttribute.getValues()) {
                this.importContext.importType(element);
            }
        }
    }

    protected String getPackageDeclaration(String pkgName) {
        if (pkgName != null && pkgName.trim().length() != 0) {
            return "package " + pkgName + ";";
        }
        return "// default package";
    }

    @Override
    public String getPackageDeclaration() {
        String pkgName = this.getPackageName();
        return this.getPackageDeclaration(pkgName);
    }

    @Override
    public String getPackageName() {
        String generatedClass = this.getGeneratedClassName();
        return StringHelper.qualifier((String)generatedClass.trim());
    }

    @Override
    public String getShortName() {
        return this.qualifyInnerClass(StringHelper.unqualify((String)this.getMappedClassName()));
    }

    @Override
    public String getQualifiedDeclarationName() {
        String generatedName = this.qualifyInnerClass(this.getGeneratedClassName());
        String qualifier = StringHelper.qualifier((String)this.getMappedClassName());
        if ("".equals(qualifier)) {
            return qualifier + "." + generatedName;
        }
        return generatedName;
    }

    @Override
    public String getDeclarationName() {
        return this.qualifyInnerClass(StringHelper.unqualify((String)this.getGeneratedClassName()));
    }

    protected String getGeneratedClassName() {
        String generatedClass = this.getMetaAsString("generated-class").trim();
        if (StringHelper.isEmpty((String)generatedClass)) {
            generatedClass = this.getMappedClassName();
        }
        if (generatedClass == null) {
            return "";
        }
        return generatedClass;
    }

    protected String qualifyInnerClass(String className) {
        return className.replace('$', '.');
    }

    protected abstract String getMappedClassName();

    public String getMetaAsString(String attribute) {
        MetaAttribute c = this.meta.getMetaAttribute(attribute);
        return MetaAttributeHelper.getMetaAsString(c);
    }

    public boolean hasMetaAttribute(String attribute) {
        return this.meta.getMetaAttribute(attribute) != null;
    }

    public String getMetaAsString(String attribute, String seperator) {
        return MetaAttributeHelper.getMetaAsString(this.meta.getMetaAttribute(attribute), seperator);
    }

    public boolean getMetaAsBool(String attribute) {
        return this.getMetaAsBool(attribute, false);
    }

    public boolean getMetaAsBool(String attribute, boolean defaultValue) {
        return MetaAttributeHelper.getMetaAsBool(this.meta.getMetaAttribute(attribute), defaultValue);
    }

    @Override
    public String getClassJavaDoc(String fallback, int indent) {
        MetaAttribute c = this.meta.getMetaAttribute("class-description");
        if (c == null) {
            return this.c2j.toJavaDoc(fallback, indent);
        }
        return this.c2j.toJavaDoc(this.getMetaAsString("class-description"), indent);
    }

    @Override
    public String getClassModifiers() {
        String classModifiers = null;
        if (this.meta.getMetaAttribute("scope-class") != null) {
            classModifiers = this.getMetaAsString("scope-class").trim();
        }
        if (this.meta.getMetaAttribute("class-modifier") != null) {
            classModifiers = this.getMetaAsString("class-modifier").trim();
        }
        return classModifiers == null ? "public" : classModifiers;
    }

    @Override
    public String getDeclarationType() {
        boolean isInterface = this.isInterface();
        if (isInterface) {
            return "interface";
        }
        return "class";
    }

    @Override
    public boolean isInterface() {
        return this.getMetaAsBool("interface");
    }

    @Override
    public String getExtendsDeclaration() {
        String extendz = this.getExtends();
        if (extendz == null || extendz.trim().length() == 0) {
            return "";
        }
        return "extends " + extendz;
    }

    @Override
    public String getImplementsDeclaration() {
        String implementz = this.getImplements();
        if (implementz == null || implementz.trim().length() == 0) {
            return "";
        }
        return "implements " + implementz;
    }

    @Override
    public String generateEquals(String thisName, String otherName, boolean useGenerics) {
        Iterator<Property> allPropertiesIterator = this.getEqualsHashCodePropertiesIterator();
        return this.generateEquals(thisName, otherName, allPropertiesIterator, useGenerics);
    }

    @Override
    public abstract Iterator<Property> getAllPropertiesIterator();

    protected String generateEquals(String thisName, String otherName, Iterator<Property> allPropertiesIterator, boolean useGenerics) {
        StringBuffer buf = new StringBuffer();
        while (allPropertiesIterator.hasNext()) {
            Property property = allPropertiesIterator.next();
            if (buf.length() > 0) {
                buf.append("\n && ");
            }
            String javaTypeName = this.c2j.getJavaTypeName(property, useGenerics, this);
            buf.append(this.internalgenerateEquals(javaTypeName, thisName + "." + this.getGetterSignature(property) + "()", otherName + "." + this.getGetterSignature(property) + "()"));
        }
        if (buf.length() == 0) {
            return "false";
        }
        return buf.toString();
    }

    private boolean usePropertyInEquals(Property property) {
        boolean hasEqualsMetaAttribute = this.c2j.hasMetaAttribute((MetaAttributable)property, "use-in-equals");
        boolean useInEquals = this.c2j.getMetaAsBool((MetaAttributable)property, "use-in-equals");
        if (property.isNaturalIdentifier()) {
            return !hasEqualsMetaAttribute || useInEquals;
        }
        return useInEquals;
    }

    private boolean useCompareTo(String javaTypeName) {
        return "java.math.BigDecimal".equals(javaTypeName);
    }

    private String internalgenerateEquals(String typeName, String lh, String rh) {
        if (this.c2j.isPrimitive(typeName)) {
            return "(" + lh + "==" + rh + ")";
        }
        if (this.useCompareTo(typeName)) {
            return "( (" + lh + "==" + rh + ") || ( " + lh + "!=null && " + rh + "!=null && " + lh + ".compareTo(" + rh + ")==0 ) )";
        }
        if (typeName.endsWith("[]")) {
            return "( (" + lh + "==" + rh + ") || ( " + lh + "!=null && " + rh + "!=null && " + this.importType("java.util.Arrays") + ".equals(" + lh + ", " + rh + ") ) )";
        }
        return "( (" + lh + "==" + rh + ") || ( " + lh + "!=null && " + rh + "!=null && " + lh + ".equals(" + rh + ") ) )";
    }

    @Override
    public String getExtraClassCode() {
        return this.getMetaAsString("class-code", "\n");
    }

    private boolean needsEqualsHashCode(Iterator<?> iter) {
        while (iter.hasNext()) {
            Property element = (Property)iter.next();
            if (!this.usePropertyInEquals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsEqualsHashCode() {
        Iterator<Property> iter = this.getAllPropertiesIterator();
        return this.needsEqualsHashCode(iter);
    }

    @Override
    public abstract String getExtends();

    @Override
    public abstract String getImplements();

    @Override
    public String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public String generateBasicAnnotation(Property property) {
        StringBuffer annotations = new StringBuffer("    ");
        if (property.getValue() instanceof SimpleValue) {
            String typeName;
            if (this.hasVersionProperty() && property.equals(this.getVersionProperty())) {
                this.buildVersionAnnotation(annotations);
            }
            if ("date".equals(typeName = ((SimpleValue)property.getValue()).getTypeName()) || "java.sql.Date".equals(typeName)) {
                this.buildTemporalAnnotation(annotations, "DATE");
            } else if ("timestamp".equals(typeName) || "java.sql.Timestamp".equals(typeName)) {
                this.buildTemporalAnnotation(annotations, "TIMESTAMP");
            } else if ("time".equals(typeName) || "java.sql.Time".equals(typeName)) {
                this.buildTemporalAnnotation(annotations, "TIME");
            }
        }
        return annotations.toString();
    }

    private StringBuffer buildTemporalAnnotation(StringBuffer annotations, String temporalTypeValue) {
        String temporal = this.importType("jakarta.persistence.Temporal");
        String temporalType = this.importType("jakarta.persistence.TemporalType");
        return annotations.append("@" + temporal + "(" + temporalType + "." + temporalTypeValue + ")");
    }

    private StringBuffer buildVersionAnnotation(StringBuffer annotations) {
        String version = this.importType("jakarta.persistence.Version");
        return annotations.append("@" + version);
    }

    @Override
    public String generateAnnColumnAnnotation(Property property) {
        StringBuffer annotations = new StringBuffer("    ");
        boolean insertable = property.isInsertable();
        boolean updatable = property.isUpdateable();
        if (property.isComposite()) {
            annotations.append("@" + this.importType("jakarta.persistence.AttributeOverrides") + "( {");
            Component component = (Component)property.getValue();
            Iterator subElements = component.getPropertyIterator();
            this.buildRecursiveAttributeOverride(subElements, null, property, annotations);
            annotations.setLength(annotations.length() - 2);
            annotations.append(" } )");
        } else if (property.getColumnSpan() == 1) {
            Selectable selectable = (Selectable)property.getColumns().get(0);
            this.buildColumnAnnotation(selectable, annotations, insertable, updatable);
        } else {
            annotations.append("@").append(this.importType("org.hibernate.annotations.Columns")).append("( { ");
            for (Selectable selectable : property.getColumns()) {
                if (selectable.isFormula()) continue;
                annotations.append("\n        ");
                this.buildColumnAnnotation(selectable, annotations, insertable, updatable);
                annotations.append(", ");
            }
            annotations.setLength(annotations.length() - 2);
            annotations.append(" } )");
        }
        return annotations.toString();
    }

    private void buildRecursiveAttributeOverride(Iterator<?> subElements, String path, Property property, StringBuffer annotations) {
        while (subElements.hasNext()) {
            Property subProperty = (Property)subElements.next();
            if (subProperty.isComposite()) {
                path = path != null ? (String)path + "." : "";
                path = (String)path + subProperty.getName();
                Component component = (Component)subProperty.getValue();
                this.buildRecursiveAttributeOverride(component.getPropertyIterator(), (String)path, subProperty, annotations);
                continue;
            }
            Selectable selectable = (Selectable)subProperty.getColumns().get(0);
            if (selectable.isFormula()) continue;
            annotations.append("\n        ").append("@").append(this.importType("jakarta.persistence.AttributeOverride")).append("(name=\"");
            if (path != null) {
                annotations.append((String)path).append(".");
            }
            annotations.append(subProperty.getName()).append("\"").append(", column=");
            this.buildColumnAnnotation(selectable, annotations, subProperty.isInsertable(), subProperty.isUpdateable());
            annotations.append(" ), ");
        }
    }

    private void buildColumnAnnotation(Selectable selectable, StringBuffer annotations, boolean insertable, boolean updatable) {
        if (selectable.isFormula()) {
            annotations.append("@").append(this.importType("org.hibernate.annotations.Formula")).append("(value=\"").append(selectable.getText()).append("\")");
        } else {
            Column column = (Column)selectable;
            annotations.append("@" + this.importType("jakarta.persistence.Column") + "(name=\"").append(column.getName()).append("\"");
            this.appendCommonColumnInfo(annotations, column, insertable, updatable);
            if (column.getPrecision() != null) {
                annotations.append(", precision=").append(column.getPrecision());
            }
            if (column.getScale() != null) {
                annotations.append(", scale=").append(column.getScale());
            } else if (column.getLength() != null) {
                annotations.append(", length=").append(column.getLength());
            }
            annotations.append(")");
        }
    }

    protected void appendCommonColumnInfo(StringBuffer annotations, Column column, boolean insertable, boolean updatable) {
        String sqlType;
        if (column.isUnique()) {
            annotations.append(", unique=").append(column.isUnique());
        }
        if (!column.isNullable()) {
            annotations.append(", nullable=").append(column.isNullable());
        }
        if (!insertable) {
            annotations.append(", insertable=").append(insertable);
        }
        if (!updatable) {
            annotations.append(", updatable=").append(updatable);
        }
        if (StringHelper.isNotEmpty((String)(sqlType = column.getSqlType()))) {
            annotations.append(", columnDefinition=\"").append(sqlType).append("\"");
        }
    }

    @Override
    public Iterator<Property> getToStringPropertiesIterator() {
        Iterator<Property> iter = this.getAllPropertiesIterator();
        return this.getToStringPropertiesIterator(iter);
    }

    private Iterator<Property> getToStringPropertiesIterator(Iterator<Property> iter) {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (iter.hasNext()) {
            Property element = iter.next();
            if (!this.c2j.getMetaAsBool((MetaAttributable)element, "use-in-tostring")) continue;
            properties.add(element);
        }
        return properties.iterator();
    }

    @Override
    public Iterator<Property> getEqualsHashCodePropertiesIterator() {
        Iterator<Property> iter = this.getAllPropertiesIterator();
        return this.getEqualsHashCodePropertiesIterator(iter);
    }

    private Iterator<Property> getEqualsHashCodePropertiesIterator(Iterator<Property> iter) {
        ArrayList<Property> properties = new ArrayList<Property>();
        while (iter.hasNext()) {
            Property element = iter.next();
            if (!this.usePropertyInEquals(element)) continue;
            properties.add(element);
        }
        return properties.iterator();
    }

    @Override
    public boolean needsToString() {
        Iterator<Property> iter = this.getAllPropertiesIterator();
        return this.needsToString(iter);
    }

    private boolean needsToString(Iterator<Property> iter) {
        while (iter.hasNext()) {
            Property element = iter.next();
            if (!this.c2j.getMetaAsBool((MetaAttributable)element, "use-in-tostring")) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetaAttribute(MetaAttributable pc, String attribute) {
        return pc.getMetaAttribute(attribute) != null;
    }

    public boolean getMetaAttribAsBool(MetaAttributable pc, String attribute, boolean defaultValue) {
        return MetaAttributeHelper.getMetaAsBool(pc.getMetaAttribute(attribute), defaultValue);
    }

    public boolean hasFieldJavaDoc(Property property) {
        return property.getMetaAttribute("field-description") != null;
    }

    @Override
    public String getFieldJavaDoc(Property property, int indent) {
        MetaAttribute c = property.getMetaAttribute("field-description");
        if (c == null) {
            return this.c2j.toJavaDoc("", indent);
        }
        return this.c2j.toJavaDoc(this.c2j.getMetaAsString((MetaAttributable)property, "field-description"), indent);
    }

    @Override
    public String getFieldDescription(Property property) {
        MetaAttribute c = property.getMetaAttribute("field-description");
        if (c == null) {
            return "";
        }
        return this.c2j.getMetaAsString((MetaAttributable)property, "field-description");
    }

    public String getGetterSignature(Property p) {
        String prefix = this.c2j.getJavaTypeName(p, false).equals("boolean") ? "is" : "get";
        return prefix + BasicPOJOClass.beanCapitalize(p.getName());
    }

    public String getPropertyName(Property p) {
        return BasicPOJOClass.beanCapitalize(p.getName());
    }

    public String getCollectionNameFor(Property property) {
        String str = this.getPropertyName(property);
        return NameConverter.simplePluralize(str);
    }

    public static String beanCapitalize(String fieldname) {
        if (fieldname == null || fieldname.length() == 0) {
            return fieldname;
        }
        if (fieldname.length() > 1 && Character.isUpperCase(fieldname.charAt(1))) {
            return fieldname;
        }
        char[] chars = fieldname.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public boolean isComponent(Property property) {
        Value value = property.getValue();
        return value != null && value instanceof Component;
    }

    public String generateHashCode(Property property, String result, String thisName, boolean jdk5) {
        StringBuffer buf = new StringBuffer();
        if (this.c2j.getMetaAsBool((MetaAttributable)property, "use-in-equals")) {
            String javaTypeName = this.c2j.getJavaTypeName(property, jdk5, this);
            boolean isPrimitive = this.c2j.isPrimitive(javaTypeName);
            if (isPrimitive) {
                buf.append(result).append(" = 37 * ").append(result).append(" + ");
                String thisValue = thisName + "." + this.getGetterSignature(property) + "()";
                if ("char".equals(javaTypeName) || "int".equals(javaTypeName) || "short".equals(javaTypeName) || "byte".equals(javaTypeName)) {
                    buf.append(thisValue);
                } else if ("boolean".equals(javaTypeName)) {
                    buf.append("(" + thisValue + "?1:0)");
                } else {
                    buf.append("(int) ");
                    buf.append(thisValue);
                }
                buf.append(";");
            } else if (javaTypeName.endsWith("[]")) {
                if (jdk5) {
                    buf.append(result).append(" = 37 * ").append(result).append(" + ");
                    buf.append("( ").append(this.getGetterSignature(property)).append("() == null ? 0 : " + this.importType("java.util.Arrays") + ".hashCode(").append(thisName).append(".").append(this.getGetterSignature(property)).append("())").append(" )").append(";");
                } else {
                    buf.append(this.internalGenerateArrayHashcode(property, javaTypeName, result, thisName));
                }
            } else {
                buf.append(result).append(" = 37 * ").append(result).append(" + ");
                buf.append("( ").append(this.getGetterSignature(property)).append("() == null ? 0 : ").append(thisName).append(".").append(this.getGetterSignature(property)).append("()").append(".hashCode()").append(" )").append(";");
            }
        }
        return buf.toString();
    }

    private String internalGenerateArrayHashcode(Property property, String javaTypeName, String result, String thisName) {
        StringBuffer buf = new StringBuffer();
        String propertyHashVarName = property.getName() + "Hashcode";
        String propertyArrayName = property.getName() + "Property";
        buf.append("int ").append(propertyHashVarName).append(" = 0;\n");
        buf.append("         ").append(javaTypeName).append(" ").append(propertyArrayName).append(" = ").append(thisName).append(".").append(this.getGetterSignature(property)).append("();\n");
        buf.append("         if(").append(propertyArrayName).append(" != null) {\n");
        buf.append("             ").append(propertyHashVarName).append(" = 1;\n");
        javaTypeName.replaceAll("\\[\\]", "");
        buf.append("             for (int i=0; i<").append(propertyArrayName).append(".length; i++) {\n");
        if (javaTypeName.startsWith("long")) {
            buf.append("                 int elementHash = (int)(").append(propertyArrayName).append("[i] ^ (").append(propertyArrayName).append("[i] >>> 32));\n");
            buf.append("                 ").append(propertyHashVarName).append(" = 37 * ").append(propertyHashVarName).append(" + elementHash;\n");
        } else if (javaTypeName.startsWith("boolean")) {
            buf.append("                 ").append(propertyHashVarName).append(" = 37 * ").append(propertyHashVarName).append(" + (").append(propertyArrayName).append("[i] ? 1231 : 1237);\n");
        } else if (javaTypeName.startsWith("float")) {
            buf.append("                 ").append(propertyHashVarName).append(" = 37 * ").append(propertyHashVarName).append(" + Float.floatToIntBits(").append(propertyArrayName).append("[i]);\n");
        } else if (javaTypeName.startsWith("double")) {
            buf.append("                 long bits = Double.doubleToLongBits(").append(propertyArrayName).append("[i]);\n");
            buf.append("                 ").append(propertyHashVarName).append(" = 37 * ").append(propertyHashVarName).append(" + (int)(bits ^ (bits >>> 32));\n");
        } else if (javaTypeName.startsWith("int") || javaTypeName.startsWith("short") || javaTypeName.startsWith("char") || javaTypeName.startsWith("byte")) {
            buf.append("                 ").append(propertyHashVarName).append(" = 37 * ").append(propertyHashVarName).append(" + ").append(propertyArrayName).append("[i];\n");
        } else {
            buf.append("                 ").append(propertyHashVarName).append(" = 37 * ").append(propertyHashVarName).append(" + ").append(propertyArrayName).append("[i].hashCode();\n");
        }
        buf.append("             }\n");
        buf.append("         }\n\n");
        buf.append("         ").append(result).append(" = 37 * ").append(result).append(" + ").append(propertyHashVarName).append(";\n");
        return buf.toString();
    }

    public String getFieldModifiers(Property property) {
        return this.getModifiers(property, "scope-field", "private");
    }

    public String getPropertyGetModifiers(Property property) {
        return this.getModifiers(property, "scope-get", "public");
    }

    public String getPropertySetModifiers(Property property) {
        return this.getModifiers(property, "scope-set", "public");
    }

    private String getModifiers(Property property, String modifiername, String defaultModifiers) {
        MetaAttribute override = property.getMetaAttribute(modifiername);
        if (override != null) {
            return MetaAttributeHelper.getMetaAsString(override);
        }
        return defaultModifiers;
    }

    protected boolean isRequiredInConstructor(Property field) {
        if (this.hasMetaAttribute((MetaAttributable)field, "default-value")) {
            return false;
        }
        if (field.getValue() != null) {
            if (!field.isOptional() && field.getValueGeneratorCreator() == null) {
                return true;
            }
            if (field.getValue() instanceof Component) {
                Component c = (Component)field.getValue();
                Iterator it = c.getPropertyIterator();
                while (it.hasNext()) {
                    Property prop = (Property)it.next();
                    if (!this.isRequiredInConstructor(prop)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean needsMinimalConstructor() {
        List<Property> propClosure = this.getPropertyClosureForMinimalConstructor();
        if (propClosure.isEmpty()) {
            return false;
        }
        return !propClosure.equals(this.getPropertyClosureForFullConstructor());
    }

    @Override
    public boolean needsFullConstructor() {
        return !this.getPropertyClosureForFullConstructor().isEmpty();
    }

    @Override
    public String getJavaTypeName(Property p, boolean useGenerics) {
        return this.c2j.getJavaTypeName(p, useGenerics, this);
    }

    public boolean hasFieldInitializor(Property p, boolean useGenerics) {
        return this.getFieldInitialization(p, useGenerics) != null;
    }

    @Override
    public String getFieldInitialization(Property p, boolean useGenerics) {
        if (this.hasMetaAttribute((MetaAttributable)p, "default-value")) {
            return MetaAttributeHelper.getMetaAsString(p.getMetaAttribute("default-value"));
        }
        if (this.c2j.getJavaTypeName(p, false) == null) {
            throw new IllegalArgumentException();
        }
        if (p.getValue() instanceof Collection) {
            Collection col = (Collection)p.getValue();
            DefaultInitializor initialization = (DefaultInitializor)col.accept((ValueVisitor)new DefaultValueVisitor(true){

                @Override
                public Object accept(Bag o) {
                    return new DefaultInitializor("java.util.ArrayList", true);
                }

                @Override
                public Object accept(org.hibernate.mapping.List o) {
                    return new DefaultInitializor("java.util.ArrayList", true);
                }

                @Override
                public Object accept(Map o) {
                    if (o.isSorted()) {
                        return new DefaultInitializor("java.util.TreeMap", false);
                    }
                    return new DefaultInitializor("java.util.HashMap", true);
                }

                @Override
                public Object accept(IdentifierBag o) {
                    return new DefaultInitializor("java.util.ArrayList", true);
                }

                @Override
                public Object accept(Set o) {
                    if (o.isSorted()) {
                        return new DefaultInitializor("java.util.TreeSet", false);
                    }
                    return new DefaultInitializor("java.util.HashSet", true);
                }

                @Override
                public Object accept(PrimitiveArray o) {
                    return null;
                }

                @Override
                public Object accept(Array o) {
                    return null;
                }
            });
            if (initialization != null) {
                String comparator = null;
                String decl = null;
                if (col.isSorted()) {
                    comparator = col.getComparatorClassName();
                }
                if (useGenerics) {
                    decl = this.c2j.getGenericCollectionDeclaration((Collection)p.getValue(), true, this.importContext);
                }
                return initialization.getDefaultValue(comparator, decl, this);
            }
            return null;
        }
        return null;
    }

    static {
        defaultInitializors.put("java.util.List", new DefaultInitializor("java.util.ArrayList", true));
        defaultInitializors.put("java.util.Map", new DefaultInitializor("java.util.HashMap", true));
        defaultInitializors.put("java.util.Set", new DefaultInitializor("java.util.HashSet", true));
        defaultInitializors.put("java.util.SortedSet", new DefaultInitializor("java.util.TreeSet", false));
        defaultInitializors.put("java.util.SortedMap", new DefaultInitializor("java.util.TreeMap", false));
    }

    private static class DefaultInitializor {
        private final String type;
        private final boolean initToZero;

        public DefaultInitializor(String type, boolean initToZero) {
            this.type = type;
            this.initToZero = initToZero;
        }

        public String getDefaultValue(String comparator, String genericDeclaration, ImportContext importContext) {
            StringBuffer val = new StringBuffer("new " + importContext.importType(this.type));
            if (genericDeclaration != null) {
                val.append(genericDeclaration);
            }
            val.append("(");
            if (comparator != null) {
                val.append("new ");
                val.append(importContext.importType(comparator));
                val.append("()");
                if (this.initToZero) {
                    val.append(",");
                }
            }
            if (this.initToZero) {
                val.append("0");
            }
            val.append(")");
            return val.toString();
        }
    }
}

