/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.lint;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.Metadata;
import org.hibernate.tool.internal.export.lint.BadCachingDetector;
import org.hibernate.tool.internal.export.lint.Detector;
import org.hibernate.tool.internal.export.lint.InstrumentationDetector;
import org.hibernate.tool.internal.export.lint.Issue;
import org.hibernate.tool.internal.export.lint.IssueCollector;
import org.hibernate.tool.internal.export.lint.SchemaByMetaDataDetector;
import org.hibernate.tool.internal.export.lint.ShadowedIdentifierDetector;

public class HbmLint
implements IssueCollector {
    final Detector[] detectors;
    List<Issue> results = new ArrayList<Issue>();

    public HbmLint(Detector[] detectors) {
        this.detectors = detectors;
    }

    public void analyze(Metadata metadata) {
        for (int i = 0; i < this.detectors.length; ++i) {
            this.detectors[i].initialize(metadata);
            this.detectors[i].visit(this);
        }
    }

    @Override
    public void reportIssue(Issue analyze) {
        this.results.add(analyze);
    }

    public List<Issue> getResults() {
        return this.results;
    }

    public static HbmLint createInstance() {
        return new HbmLint(new Detector[]{new BadCachingDetector(), new InstrumentationDetector(), new ShadowedIdentifierDetector(), new SchemaByMetaDataDetector()});
    }
}

