/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filter;
import org.hibernate.validator.internal.util.privilegedactions.GetMethods;

class InheritedMethodsHelper {
    private InheritedMethodsHelper() {
    }

    static List<Method> getAllMethods(Class<?> clazz) {
        Contracts.assertNotNull(clazz);
        ArrayList methods = CollectionHelper.newArrayList();
        for (Class hierarchyClass : ClassHierarchyHelper.getHierarchy(clazz, (Filter[])new Filter[0])) {
            Collections.addAll(methods, (Object[])InheritedMethodsHelper.run(GetMethods.action((Class)hierarchyClass)));
        }
        return methods;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

