/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.samples.complex;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.integration.IterativeLegendreGaussIntegrator;
import org.hipparchus.analysis.integration.UnivariateIntegrator;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.ComplexUnivariateIntegrator;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.samples.complex.ContinuousModuleValue;
import org.hipparchus.samples.complex.DomainColoring;
import org.hipparchus.samples.complex.SawToothModuleValue;
import org.hipparchus.samples.complex.SawToothPhaseModuleValue;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiEllipticBuilder;
import org.hipparchus.special.elliptic.legendre.LegendreEllipticIntegral;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.RyuDouble;

public class GnuplotComplexPlotter {
    private Complex n = new Complex(3.4, 1.3);
    private Complex m = new Complex(0.64);
    private FieldJacobiElliptic<Complex> jacobi = JacobiEllipticBuilder.build((Complex)this.m);
    private List<Predefined> functions = new ArrayList<Predefined>();
    private File output = null;
    private DomainColoring coloring = new SawToothPhaseModuleValue(1.0, 0.7, 1.0, 15);
    private int width = 800;
    private int height = 800;
    private double xMin = -7.0;
    private double xMax = 7.0;
    private double yMin = -7.0;
    private double yMax = 7.0;
    private double zMax = 7.0;
    private double viewXRot = 60.0;
    private double viewZRot = 30.0;
    private boolean use3D = false;
    private int maxEval = 100000;
    final ComplexUnivariateIntegrator integrator = new ComplexUnivariateIntegrator((UnivariateIntegrator)new IterativeLegendreGaussIntegrator(24, 1.0E-6, 1.0E-6));

    private GnuplotComplexPlotter() {
    }

    public static void main(String[] args) {
        GnuplotComplexPlotter plotter = new GnuplotComplexPlotter();
        try {
            block51: for (int i = 0; i < args.length; ++i) {
                switch (args[i]) {
                    case "--help": {
                        GnuplotComplexPlotter.usage(0);
                        continue block51;
                    }
                    case "--output-dir": {
                        plotter.output = new File(args[++i]);
                        if (plotter.output.exists() && plotter.output.isDirectory() && plotter.output.canWrite()) continue block51;
                        System.err.format(Locale.US, "cannot generate output file in %s%n", plotter.output.getAbsolutePath());
                        System.exit(1);
                        continue block51;
                    }
                    case "--width": {
                        plotter.width = Integer.parseInt(args[++i]);
                        continue block51;
                    }
                    case "--height": {
                        plotter.height = Integer.parseInt(args[++i]);
                        continue block51;
                    }
                    case "--color": {
                        switch (args[++i]) {
                            case "classical": {
                                plotter.coloring = new ContinuousModuleValue(1.0);
                                continue block51;
                            }
                            case "enhanced-module": {
                                plotter.coloring = new SawToothModuleValue(1.0);
                                continue block51;
                            }
                            case "enhanced-phase-module": {
                                plotter.coloring = new SawToothPhaseModuleValue(1.0, 0.7, 1.0, 15);
                                continue block51;
                            }
                        }
                        GnuplotComplexPlotter.usage(1);
                        continue block51;
                    }
                    case "--3d": {
                        plotter.use3D = true;
                        continue block51;
                    }
                    case "--view": {
                        plotter.viewXRot = Double.parseDouble(args[++i]);
                        plotter.viewZRot = Double.parseDouble(args[++i]);
                        continue block51;
                    }
                    case "--xmin": {
                        plotter.xMin = Double.parseDouble(args[++i]);
                        continue block51;
                    }
                    case "--xmax": {
                        plotter.xMax = Double.parseDouble(args[++i]);
                        continue block51;
                    }
                    case "--ymin": {
                        plotter.yMin = Double.parseDouble(args[++i]);
                        continue block51;
                    }
                    case "--ymax": {
                        plotter.yMax = Double.parseDouble(args[++i]);
                        continue block51;
                    }
                    case "--zmax": {
                        plotter.zMax = Double.parseDouble(args[++i]);
                        continue block51;
                    }
                    case "--m": {
                        plotter.m = new Complex(Double.parseDouble(args[++i]), Double.parseDouble(args[++i]));
                        plotter.jacobi = JacobiEllipticBuilder.build((Complex)plotter.m);
                        continue block51;
                    }
                    case "--n": {
                        plotter.n = new Complex(Double.parseDouble(args[++i]), Double.parseDouble(args[++i]));
                        continue block51;
                    }
                    case "--maxeval": {
                        plotter.maxEval = Integer.parseInt(args[++i]);
                        continue block51;
                    }
                    case "--function": {
                        try {
                            plotter.functions.add(Predefined.valueOf(args[++i]));
                        }
                        catch (IllegalArgumentException iae) {
                            System.err.format(Locale.US, "unknown function %s, known functions:%n", args[i]);
                            for (Predefined predefined : Predefined.values()) {
                                System.err.format(Locale.US, " %s", predefined.name());
                            }
                            System.err.format(Locale.US, "%n", new Object[0]);
                            System.exit(1);
                        }
                        continue block51;
                    }
                    default: {
                        GnuplotComplexPlotter.usage(1);
                    }
                }
            }
            if (plotter.functions.isEmpty()) {
                GnuplotComplexPlotter.usage(1);
            }
            plotter.plot();
        }
        catch (IndexOutOfBoundsException iobe) {
            GnuplotComplexPlotter.usage(1);
        }
        catch (IOException ioe) {
            System.err.println(ioe.getLocalizedMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    private static void usage(int status) {
        System.err.println("usage: java org.hipparchus.samples.complex.GnuplotComplexPlotter [--help] [--output-dir directory] [--3d] [--view xRot zRot] [--color {classical|enhanced-module|enhanced-phase-module}] [--xmin xMin] [--xmax xMax] [--ymin yMin] [--ymax yMax] [--zmax zMax] [--m mRe mIm] [--n nRe nIm] [--maxeval maxEval] --function {id|sn|cn|dn|cs|...|sin|cos|...} [--function ...]");
        System.exit(status);
    }

    public void plot() throws IOException {
        for (Predefined predefined : this.functions) {
            ProcessBuilder pb = new ProcessBuilder("gnuplot").redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
            pb.environment().remove("XDG_SESSION_TYPE");
            Process gnuplot = pb.start();
            PrintStream out = new PrintStream(gnuplot.getOutputStream(), false, StandardCharsets.UTF_8.name());
            Throwable throwable = null;
            try {
                if (this.output == null) {
                    out.format(Locale.US, "set terminal qt size %d, %d title 'complex plotter'%n", this.width, this.height);
                } else {
                    out.format(Locale.US, "set terminal pngcairo size %d, %d%n", this.width, this.height);
                    out.format(Locale.US, "set output '%s'%n", new File(this.output, predefined.name() + ".png").getAbsolutePath());
                }
                out.format(Locale.US, "set xrange [%f : %f]%n", this.xMin, this.xMax);
                out.format(Locale.US, "set yrange [%f : %f]%n", this.yMin, this.yMax);
                if (this.use3D) {
                    out.format(Locale.US, "set zrange [%f : %f]%n", 0.0, this.zMax);
                }
                out.format(Locale.US, "set xlabel 'Re(z)'%n", new Object[0]);
                out.format(Locale.US, "set ylabel 'Im(z)'%n", new Object[0]);
                out.format(Locale.US, "set key off%n", new Object[0]);
                out.format(Locale.US, "unset colorbox%n", new Object[0]);
                out.format(Locale.US, "set title '%s'%n", predefined.title(this.m));
                out.format(Locale.US, "$data <<EOD%n", new Object[0]);
                for (int i = 0; i < this.width; ++i) {
                    double x = this.xMin + (double)i * (this.xMax - this.xMin) / (double)(this.width - 1);
                    for (int j = 0; j < this.height; ++j) {
                        Complex fz;
                        double y = this.yMin + (double)j * (this.yMax - this.yMin) / (double)(this.height - 1);
                        Complex z = Complex.valueOf((double)x, (double)y);
                        try {
                            fz = predefined.evaluator.value(this, z);
                        }
                        catch (MathIllegalStateException e) {
                            fz = Complex.NaN;
                        }
                        out.format(Locale.US, "%12.9f %12.9f %12.9f %12.9f %12.9f %12.9f%n", z.getRealPart(), z.getImaginaryPart(), fz.norm(), this.coloring.hue(fz), this.coloring.saturation(fz), this.coloring.value(fz));
                    }
                    out.format(Locale.US, "%n", new Object[0]);
                }
                out.format(Locale.US, "EOD%n", new Object[0]);
                if (this.use3D) {
                    out.format(Locale.US, "set view %f, %f%n", this.viewXRot, this.viewZRot);
                    out.format(Locale.US, "splot $data using 1:2:3:(hsv2rgb($4,$5,$6)) with pm3d lc rgb variable%n", new Object[0]);
                } else {
                    out.format(Locale.US, "set view map scale 1%n", new Object[0]);
                    out.format(Locale.US, "splot $data using 1:2:(hsv2rgb($4,$5,$6)) with pm3d lc rgb variable%n", new Object[0]);
                }
                if (this.output == null) {
                    out.format(Locale.US, "pause mouse close%n", new Object[0]);
                    continue;
                }
                System.out.format(Locale.US, "output written to %s%n", new File(this.output, predefined.name() + ".png").getAbsolutePath());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private static enum Predefined {
        id((plotter, z) -> z),
        sn((plotter, z) -> (Complex)plotter.jacobi.valuesN((CalculusFieldElement)z).sn()),
        cn((plotter, z) -> (Complex)plotter.jacobi.valuesN((CalculusFieldElement)z).cn()),
        dn((plotter, z) -> (Complex)plotter.jacobi.valuesN((CalculusFieldElement)z).dn()),
        cs((plotter, z) -> (Complex)plotter.jacobi.valuesS((CalculusFieldElement)z).cs()),
        ds((plotter, z) -> (Complex)plotter.jacobi.valuesS((CalculusFieldElement)z).ds()),
        ns((plotter, z) -> (Complex)plotter.jacobi.valuesS((CalculusFieldElement)z).ns()),
        dc((plotter, z) -> (Complex)plotter.jacobi.valuesC((CalculusFieldElement)z).dc()),
        nc((plotter, z) -> (Complex)plotter.jacobi.valuesC((CalculusFieldElement)z).nc()),
        sc((plotter, z) -> (Complex)plotter.jacobi.valuesC((CalculusFieldElement)z).sc()),
        nd((plotter, z) -> (Complex)plotter.jacobi.valuesD((CalculusFieldElement)z).nd()),
        sd((plotter, z) -> (Complex)plotter.jacobi.valuesD((CalculusFieldElement)z).sd()),
        cd((plotter, z) -> (Complex)plotter.jacobi.valuesD((CalculusFieldElement)z).cd()),
        arcsn((plotter, z) -> (Complex)plotter.jacobi.arcsn((CalculusFieldElement)z)),
        arccn((plotter, z) -> (Complex)plotter.jacobi.arccn((CalculusFieldElement)z)),
        arcdn((plotter, z) -> (Complex)plotter.jacobi.arcdn((CalculusFieldElement)z)),
        arccs((plotter, z) -> (Complex)plotter.jacobi.arccs((CalculusFieldElement)z)),
        arcds((plotter, z) -> (Complex)plotter.jacobi.arcds((CalculusFieldElement)z)),
        arcns((plotter, z) -> (Complex)plotter.jacobi.arcns((CalculusFieldElement)z)),
        arcdc((plotter, z) -> (Complex)plotter.jacobi.arcdc((CalculusFieldElement)z)),
        arcnc((plotter, z) -> (Complex)plotter.jacobi.arcnc((CalculusFieldElement)z)),
        arcsc((plotter, z) -> (Complex)plotter.jacobi.arcsc((CalculusFieldElement)z)),
        arcnd((plotter, z) -> (Complex)plotter.jacobi.arcnd((CalculusFieldElement)z)),
        arcsd((plotter, z) -> (Complex)plotter.jacobi.arcsd((CalculusFieldElement)z)),
        arccd((plotter, z) -> (Complex)plotter.jacobi.arccd((CalculusFieldElement)z)),
        K((plotter, z) -> LegendreEllipticIntegral.bigK((Complex)z)),
        KPrime((plotter, z) -> LegendreEllipticIntegral.bigKPrime((Complex)z)),
        Fzm((plotter, z) -> LegendreEllipticIntegral.bigF((Complex)z, (Complex)plotter.m)),
        integratedFzm((plotter, z) -> LegendreEllipticIntegral.bigF((Complex)z, (Complex)plotter.m, (ComplexUnivariateIntegrator)plotter.integrator, (int)plotter.maxEval)),
        E((plotter, z) -> LegendreEllipticIntegral.bigE((Complex)z)),
        Ezm((plotter, z) -> LegendreEllipticIntegral.bigE((Complex)z, (Complex)plotter.m)),
        integratedEzm((plotter, z) -> LegendreEllipticIntegral.bigE((Complex)z, (Complex)plotter.m, (ComplexUnivariateIntegrator)plotter.integrator, (int)plotter.maxEval)),
        Pi((plotter, z) -> LegendreEllipticIntegral.bigPi((Complex)plotter.n, (Complex)z)),
        Pizm((plotter, z) -> LegendreEllipticIntegral.bigPi((Complex)plotter.n, (Complex)z, (Complex)plotter.m)),
        integratedPizm((plotter, z) -> LegendreEllipticIntegral.bigPi((Complex)plotter.n, (Complex)z, (Complex)plotter.m, (ComplexUnivariateIntegrator)plotter.integrator, (int)plotter.maxEval)),
        sin((plotter, z) -> (Complex)FastMath.sin((CalculusFieldElement)z)),
        cos((plotter, z) -> (Complex)FastMath.cos((CalculusFieldElement)z)),
        tan((plotter, z) -> (Complex)FastMath.tan((CalculusFieldElement)z)),
        asin((plotter, z) -> (Complex)FastMath.asin((CalculusFieldElement)z)),
        acos((plotter, z) -> (Complex)FastMath.acos((CalculusFieldElement)z)),
        atan((plotter, z) -> (Complex)FastMath.atan((CalculusFieldElement)z)),
        sinh((plotter, z) -> (Complex)FastMath.sinh((CalculusFieldElement)z)),
        cosh((plotter, z) -> (Complex)FastMath.cosh((CalculusFieldElement)z)),
        tanh((plotter, z) -> (Complex)FastMath.tanh((CalculusFieldElement)z)),
        asinh((plotter, z) -> (Complex)FastMath.asinh((CalculusFieldElement)z)),
        acosh((plotter, z) -> (Complex)FastMath.acosh((CalculusFieldElement)z)),
        atanh((plotter, z) -> (Complex)FastMath.atanh((CalculusFieldElement)z));

        private final Evaluator evaluator;

        private Predefined(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public String title(Complex m) {
            if (this.name().endsWith("zm")) {
                return this.name().substring(0, this.name().length() - 2) + "(z, m = " + RyuDouble.doubleToString((double)m.getRealPart()) + (m.getImaginary() >= 0.0 ? " + " : " - ") + RyuDouble.doubleToString((double)FastMath.abs((double)m.getImaginaryPart())) + "i)";
            }
            return this.name() + "(z)";
        }
    }

    private static interface Evaluator {
        public Complex value(GnuplotComplexPlotter var1, Complex var2);
    }
}

