package org.hnau.emitter.extensions

import org.hnau.base.extensions.boolean.checkTruth
import org.hnau.emitter.Emitter
import org.hnau.emitter.observing.push.possible.collapse


fun <T> Emitter<T>.useWhen(
        isNeedUse: Emitter<Boolean>,
        placeholder: Emitter<T> = Emitter.empty<T>()
) = isNeedUse.map { needUse ->
    needUse.checkTruth(
            ifTrue = { this@useWhen },
            ifFalse = { placeholder }
    )
}.collapse()
