package org.hnau.emitter.extensions

import org.hnau.emitter.Detacher
import org.hnau.emitter.Emitter


inline fun <T> Emitter.Companion.create(
        crossinline onObserverAttached: ((T) -> Unit) -> Detacher
) = object : Emitter<T> {
    override fun observe(observer: (T) -> Unit) =
            onObserverAttached(observer)
}

inline fun <T> Emitter.Companion.simple(
        crossinline getter: () -> T
) = create<T> { observer ->
    observer(getter())
    Detacher.EMPTY
}

fun <T> Emitter.Companion.single(value: T) =
        Emitter.simple { value }

private val falseEmitter by lazy { Emitter.single(false) }
val Emitter.Companion.alwaysFalse get() = falseEmitter

private val trueEmitter by lazy { Emitter.single(true) }
val Emitter.Companion.alwaysTrue get() = trueEmitter

private val unitEmitter by lazy { Emitter.single(Unit) }
val Emitter.Companion.alwaysUnit get() = unitEmitter

fun <T> Emitter.Companion.empty() =
        Emitter.create<T> { Detacher.EMPTY }