package org.hnau.emitter.extensions

import org.hnau.emitter.Detacher
import org.hnau.emitter.Emitter


inline fun <T> Emitter<T>.observeWithDetacher(
        crossinline observer: (value: T, detacher: Detacher) -> Unit
) {
    var detacher: Detacher? = null
    var detached = false
    val detacherInner = Detacher.create {
        detached = true
        detacher?.detach()
    }

    detacher = observe { value -> observer(value, detacherInner) }

    if (detached) {
        detacher.detach()
    }
}