package org.hnau.emitter.extensions

import org.hnau.emitter.Emitter
import kotlin.coroutines.resume
import kotlin.coroutines.suspendCoroutine


suspend inline fun <T> Emitter<T>.wait(
        crossinline predicate: (T) -> Boolean = { _ -> true }
) = suspendCoroutine<T> { continuation ->
    var finished = false
    observeWithDetacher { value, detacher ->
        value
                .takeIf { !finished && predicate(it) }
                ?.let { valueInner ->
                    finished = true
                    detacher.detach()
                    continuation.resume(valueInner)
                }
    }

}