package org.hnau.emitter.extensions.byte

import org.hnau.base.extensions.number.and
import org.hnau.base.extensions.number.or
import org.hnau.base.extensions.number.xor
import org.hnau.emitter.Emitter
import org.hnau.emitter.extensions.map
import org.hnau.emitter.observing.push.possible.combineWith


fun Emitter<Byte>.toByte() = map(Byte::toByte)

operator fun Emitter<Byte>.plus(other: Emitter<Byte>) = combineWith(other, Byte::plus)
operator fun Emitter<Byte>.minus(other: Emitter<Byte>) = combineWith(other, Byte::minus)
operator fun Emitter<Byte>.times(other: Emitter<Byte>) = combineWith(other, Byte::times)
operator fun Emitter<Byte>.div(other: Emitter<Byte>) = combineWith(other, Byte::div)
operator fun Emitter<Byte>.rem(other: Emitter<Byte>) = combineWith(other, Byte::rem)
operator fun Emitter<Byte>.rangeTo(other: Emitter<Byte>) = combineWith<Byte, Byte, IntRange>(other, Byte::rangeTo)

operator fun Emitter<Byte>.plus(other: Byte) = map { it + other }
operator fun Emitter<Byte>.minus(other: Byte) = map { it - other }
operator fun Emitter<Byte>.times(other: Byte) = map { it * other }
operator fun Emitter<Byte>.div(other: Byte) = map { it / other }
operator fun Emitter<Byte>.rem(other: Byte) = map { it % other }
operator fun Emitter<Byte>.rangeTo(other: Byte) = map { it..other }

operator fun Byte.plus(other: Emitter<Byte>) = other.map { this + it }
operator fun Byte.minus(other: Emitter<Byte>) = other.map { this - it }
operator fun Byte.times(other: Emitter<Byte>) = other.map { this * it }
operator fun Byte.div(other: Emitter<Byte>) = other.map { this / it }
operator fun Byte.rem(other: Emitter<Byte>) = other.map { this % it }
operator fun Byte.rangeTo(other: Emitter<Byte>) = other.map { this..it }

infix fun Emitter<Byte>.and(other: Emitter<Byte>) = combineWith(other, Byte::and)
infix fun Emitter<Byte>.or(other: Emitter<Byte>) = combineWith(other, Byte::or)
infix fun Emitter<Byte>.xor(other: Emitter<Byte>) = combineWith(other, Byte::xor)
infix fun Emitter<Byte>.and(other: Byte) = map { it and other }
infix fun Emitter<Byte>.or(other: Byte) = map { it or other }
infix fun Emitter<Byte>.xor(other: Byte) = map { it xor other }
infix fun Byte.and(other: Emitter<Byte>) = other.map { this and it }
infix fun Byte.or(other: Emitter<Byte>) = other.map { this or it }
infix fun Byte.xor(other: Emitter<Byte>) = other.map { this xor it }