 package org.hnau.emitter.extensions.double

import org.hnau.emitter.Emitter
import org.hnau.emitter.extensions.map
import org.hnau.emitter.observing.push.possible.combineWith


 fun Emitter<Double>.toFloat() = map(Double::toFloat)

operator fun Emitter<Double>.plus(other: Emitter<Float>) = combineWith(other, Double::plus)
operator fun Emitter<Double>.minus(other: Emitter<Float>) = combineWith(other, Double::minus)
operator fun Emitter<Double>.times(other: Emitter<Float>) = combineWith(other, Double::times)
operator fun Emitter<Double>.div(other: Emitter<Float>) = combineWith(other, Double::div)
operator fun Emitter<Double>.rem(other: Emitter<Float>) = combineWith(other, Double::rem)

operator fun Emitter<Double>.plus(other: Float) = map { it + other }
operator fun Emitter<Double>.minus(other: Float) = map { it - other }
operator fun Emitter<Double>.times(other: Float) = map { it * other }
operator fun Emitter<Double>.div(other: Float) = map { it / other }
operator fun Emitter<Double>.rem(other: Float) = map { it % other }

operator fun Double.plus(other: Emitter<Float>) = other.map { this + it }
operator fun Double.minus(other: Emitter<Float>) = other.map { this - it }
operator fun Double.times(other: Emitter<Float>) = other.map { this * it }
operator fun Double.div(other: Emitter<Float>) = other.map { this / it }
operator fun Double.rem(other: Emitter<Float>) = other.map { this % it }