package org.hnau.emitter.extensions.short

import org.hnau.base.extensions.number.and
import org.hnau.base.extensions.number.or
import org.hnau.base.extensions.number.xor
import org.hnau.emitter.Emitter
import org.hnau.emitter.extensions.map
import org.hnau.emitter.observing.push.possible.combineWith


fun Emitter<Short>.toShort() = map(Short::toShort)

operator fun Emitter<Short>.plus(other: Emitter<Short>) = combineWith(other, Short::plus)
operator fun Emitter<Short>.minus(other: Emitter<Short>) = combineWith(other, Short::minus)
operator fun Emitter<Short>.times(other: Emitter<Short>) = combineWith(other, Short::times)
operator fun Emitter<Short>.div(other: Emitter<Short>) = combineWith(other, Short::div)
operator fun Emitter<Short>.rem(other: Emitter<Short>) = combineWith(other, Short::rem)
operator fun Emitter<Short>.rangeTo(other: Emitter<Short>) = combineWith<Short, Short, IntRange>(other, Short::rangeTo)

operator fun Emitter<Short>.plus(other: Short) = map { it + other }
operator fun Emitter<Short>.minus(other: Short) = map { it - other }
operator fun Emitter<Short>.times(other: Short) = map { it * other }
operator fun Emitter<Short>.div(other: Short) = map { it / other }
operator fun Emitter<Short>.rem(other: Short) = map { it % other }
operator fun Emitter<Short>.rangeTo(other: Short) = map { it..other }

operator fun Short.plus(other: Emitter<Short>) = other.map { this + it }
operator fun Short.minus(other: Emitter<Short>) = other.map { this - it }
operator fun Short.times(other: Emitter<Short>) = other.map { this * it }
operator fun Short.div(other: Emitter<Short>) = other.map { this / it }
operator fun Short.rem(other: Emitter<Short>) = other.map { this % it }
operator fun Short.rangeTo(other: Emitter<Short>) = other.map { this..it }

infix fun Emitter<Short>.and(other: Emitter<Short>) = combineWith(other, Short::and)
infix fun Emitter<Short>.or(other: Emitter<Short>) = combineWith(other, Short::or)
infix fun Emitter<Short>.xor(other: Emitter<Short>) = combineWith(other, Short::xor)
infix fun Emitter<Short>.and(other: Short) = map { it and other }
infix fun Emitter<Short>.or(other: Short) = map { it or other }
infix fun Emitter<Short>.xor(other: Short) = map { it xor other }
infix fun Short.and(other: Emitter<Short>) = other.map { this and it }
infix fun Short.or(other: Emitter<Short>) = other.map { this or it }
infix fun Short.xor(other: Emitter<Short>) = other.map { this xor it }