package org.hnau.emitter.extensions.time

import org.hnau.base.data.Time
import org.hnau.base.extensions.time.times
import org.hnau.emitter.Emitter
import org.hnau.emitter.extensions.map
import org.hnau.emitter.observing.push.possible.combineWith

operator fun Emitter<Number>.times(other: Emitter<Time>) = combineWith(other, Number::times)
operator fun Emitter<Number>.times(other: Time) = map { it * other }
operator fun Number.times(other: Emitter<Time>) = other.map { this * it }