package org.hnau.emitter.observing.push.always.content

import org.hnau.base.extensions.boolean.ifTrue


class LockedEmitter : ContentEmitter<Boolean>(false) {

    private var blocksCount = 0
        set(blocksCount) {
            field = blocksCount
            val locked = blocksCount > 0
            (value != locked).ifTrue { value = locked }
        }

    private fun updateBlocksCount(
            delta: Int
    ) = synchronized(this) {
        blocksCount = (blocksCount + delta).coerceAtLeast(0)
    }

    @Deprecated("Should have been private, but inline fun <T> executeLocked(block: () -> T) expected using only public methods")
    fun incBlocksCount() = updateBlocksCount(1)

    @Deprecated("Should have been private, but inline fun <T> executeLocked(block: () -> T) expected using only public methods")
    fun decBlocksCount() = updateBlocksCount(-1)

    @Suppress("DEPRECATION")
    inline fun <T> executeLocked(
            block: () -> T
    ) = try {
        incBlocksCount()
        block()
    } finally {
        decBlocksCount()
    }

    inline operator fun <T> invoke(block: () -> T) = executeLocked(block)

}
