package org.hnau.emitter.observing.push.possible

import org.hnau.base.extensions.boolean.ifTrue
import org.hnau.emitter.Emitter
import org.hnau.emitter.utils.Detachers
import org.hnau.emitter.utils.observe


class CacheEmitter<T : Any>(
        private val source: Emitter<T>,
        private val clearAfterLastDetached: Boolean = false
) : PossibleEmitter<T>() {

    private val detachers = Detachers()

    override fun beforeFirstAttached() {
        source.observe(detachers, this::set)
        super.beforeFirstAttached()
    }

    override fun afterLastDetached() {
        detachers.detach()
        clearAfterLastDetached.ifTrue(this::clearAfterLastDetached)
        super.afterLastDetached()
    }

}

fun <T : Any> Emitter<T>.cache(
        clearAfterLastDetached: Boolean = false
): Emitter<T> = CacheEmitter(
        source = this,
        clearAfterLastDetached = clearAfterLastDetached
)