package org.hnau.emitter.observing.push.possible

import org.hnau.emitter.Detacher
import org.hnau.emitter.Emitter
import org.hnau.emitter.utils.Detachers
import org.hnau.emitter.utils.observe


class CollapsingEmitter<T>(
        private val source: Emitter<Emitter<T>>
) : PossibleEmitter<T>() {

    private var sourceValueDetacher: Detacher? = null
        set(value) = synchronized(this) {
            field?.detach()
            field = value
        }

    private val detachers = Detachers()

    override fun beforeFirstAttached() {
        super.beforeFirstAttached()
        source.observe(detachers) { sourceValue ->
            sourceValueDetacher = sourceValue.observe { set(it) }
        }
    }

    override fun afterLastDetached() {
        detachers.detach()
        sourceValueDetacher = null
        clear()
        super.afterLastDetached()
    }

}

fun <T> Emitter<Emitter<T>>.collapse(): Emitter<T> =
        CollapsingEmitter(this)