package org.hnau.emitter.observing.push.possible

import org.hnau.emitter.Emitter
import org.hnau.emitter.utils.Detachers
import org.hnau.emitter.utils.observe


class FunnelEmitter<T>(
        private val sources: Iterable<Emitter<T>>
) : PossibleEmitter<T>() {

    private val detachers = Detachers()

    private val onSourceCall = this::set

    override fun beforeFirstAttached() {
        super.beforeFirstAttached()
        sources.forEach { it.observe(detachers, onSourceCall) }
    }

    override fun afterLastDetached() {
        super.afterLastDetached()
        detachers.detach()
        clear()
    }

}

fun <T> Iterable<Emitter<T>>.line(): Emitter<T> =
        FunnelEmitter(this)