package org.hnau.emitter.observing.push.possible

import org.hnau.base.data.box.Box
import org.hnau.base.data.box.sync.sync
import org.hnau.base.utils.INLINE_PRIVATE_DEPRECATION
import org.hnau.emitter.observing.push.PushEmitter


abstract class PossibleEmitter<T> : PushEmitter<T>() {

    @Deprecated(INLINE_PRIVATE_DEPRECATION)
    val value = Box.sync<T>()

    @Suppress("DEPRECATION")
    inline fun <R> checkContains(
            ifContains: (value: T) -> R,
            ifNotContains: () -> R
    ) = value.checkValueExists(
            ifExists = ifContains,
            ifNotExists = ifNotContains
    )

    @Suppress("DEPRECATION")
    open fun set(value: T) {
        this.value.set(value)
        onChanged()
    }

    @Suppress("DEPRECATION")
    open fun forceClear() {
        value.clear()
        onChanged()
    }

    @Suppress("DEPRECATION")
    open fun setUnique(value: T) = synchronized(this) {
        this.value.checkValueExists(
                ifExists = { (it == value).apply { this@PossibleEmitter.value.set(value) } },
                ifNotExists = { false }
        )
    }

    @Suppress("DEPRECATION")
    open fun clear() = synchronized(this) {
        checkContains(
                ifContains = { false },
                ifNotContains = { forceClear(); true }
        )
    }

    @Suppress("UNCHECKED_CAST")
    override final fun tryGetValue(onValue: (T) -> Unit) {
        checkContains(
                ifContains = onValue,
                ifNotContains = { }
        )
    }

}

