package org.hnau.emitter.utils

import org.hnau.emitter.Detacher
import org.hnau.emitter.Emitter
import java.util.*


class Detachers {

    private val detachers = LinkedList<Detacher>()

    fun add(detacher: Detacher) {
        detachers.add(detacher)
    }

    fun detach() = synchronized(detachers) {
        detachers.forEach(Detacher::detach)
        detachers.clear()
    }

}

fun <T> Emitter<T>.observe(detachers: Detachers, observer: (T) -> Unit) =
        detachers.add(observe(observer))