package org.hnau.emitter.utils.executors

import kotlinx.coroutines.CancellationException
import kotlinx.coroutines.CoroutineScope
import org.hnau.base.extensions.boolean.ifFalse
import org.hnau.base.utils.tryOrElse
import org.hnau.emitter.extensions.callIfTrue
import java.util.*
import kotlin.collections.LinkedHashSet


class TasksFinalizer(
        private val interruptableExecutor: InterruptableExecutor
) : (suspend CoroutineScope.() -> Unit) -> Unit {

    private val tasks: MutableSet<suspend CoroutineScope.() -> Unit> =
            Collections.synchronizedSet(LinkedHashSet<suspend CoroutineScope.() -> Unit>())

    init {
        interruptableExecutor.callIfTrue().observe {
            tasks.forEach(interruptableExecutor::invoke)
        }
    }

    override fun invoke(task: suspend CoroutineScope.() -> Unit) {
        lateinit var removableTask: suspend CoroutineScope.() -> Unit
        removableTask = {
            tryOrElse(
                    action = {
                        task()
                        tasks.remove(removableTask)
                    },
                    onThrow = {th ->
                        (th is CancellationException)
                                .ifFalse { tasks.remove(removableTask) }
                    }
            )
        }
        tasks.add(removableTask)
        interruptableExecutor(removableTask)
    }

}