package org.hnau.emitter.utils.executors.job

import java.util.*


class ExecutorsFinisher {

    private val finishingExecutors: MutableSet<FinishableExecutor> =
            Collections.synchronizedSet(LinkedHashSet<FinishableExecutor>())

    fun finishExecutor(lastExecutor: FinishableExecutor) {
        finishingExecutors.add(lastExecutor)
        lastExecutor.finish { finishingExecutors.remove(it) }
    }

}