package org.hnau.emitter.utils.executors.job

import kotlinx.coroutines.CoroutineScope
import org.hnau.base.extensions.boolean.ifTrue
import org.hnau.base.extensions.launch
import kotlin.coroutines.CoroutineContext


class FinishableExecutor(
        private val cancellableContext: CancellableContext
) : (suspend CoroutineScope.() -> Unit) -> Boolean {

    data class CancellableContext(
            val context: CoroutineContext,
            val cancel: () -> Unit
    )

    private var finished = false

    fun finish(
            onFinished: (FinishableExecutor) -> Unit
    ) {
        synchronized(this) {
            finished.ifTrue { return }
            finished = true
        }
        cancellableContext.context.launch {
            cancellableContext.cancel()
            onFinished(this@FinishableExecutor)
        }
    }

    override fun invoke(
            coroutine: suspend CoroutineScope.() -> Unit
    ) = synchronized(this) {
        finished.ifTrue { return@synchronized false }
        cancellableContext.context.launch(block = coroutine)
        return@synchronized true
    }
}