package org.hnau.emitter.utils.executors.job

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.SupervisorJob
import org.hnau.emitter.Emitter
import org.hnau.emitter.utils.executors.InterruptableExecutor
import kotlin.coroutines.CoroutineContext


open class JobExecutor(
        isActive: Emitter<Boolean>
): InterruptableExecutor {

    private val switchableExecutor by lazy {
        SwitchableExecutor(
                isActive = isActive,
                cancellableContextCreator = this::createCancellableContext
        )
    }

    override fun observe(observer: (Boolean) -> Unit) =
            switchableExecutor.observe(observer)

    protected fun createCancellableContext(): FinishableExecutor.CancellableContext {
        val job = SupervisorJob()
        return FinishableExecutor.CancellableContext(
                context = createCoroutineContext(job),
                cancel = job::cancel
        )
    }

    protected open fun createCoroutineContext(job: Job): CoroutineContext = job

    override fun invoke(coroutine: suspend CoroutineScope.() -> Unit) =
            switchableExecutor(coroutine)

}