package org.hnau.emitter.utils.executors.job

import kotlinx.coroutines.CoroutineScope
import org.hnau.base.extensions.boolean.checkTruth
import org.hnau.base.extensions.boolean.ifFalse
import org.hnau.base.extensions.boolean.ifTrue
import org.hnau.emitter.Emitter
import org.hnau.emitter.extensions.map
import org.hnau.emitter.observing.push.always.AlwaysEmitter
import org.hnau.emitter.utils.executors.InterruptableExecutor


class SwitchableExecutor(
        isActive: Emitter<Boolean>,
        private val cancellableContextCreator: () -> FinishableExecutor.CancellableContext
): AlwaysEmitter<Boolean>(), InterruptableExecutor {

    private val executorsFinisher = ExecutorsFinisher()

    override val value get() = executor != null

    private var executor: FinishableExecutor? = null
        set(value) = synchronized(this) {
            field?.let(executorsFinisher::finishExecutor)
            field = value
            onChanged()
        }

    init {
        isActive
                .map { active ->
                    active.checkTruth(
                            ifTrue = { FinishableExecutor(cancellableContextCreator()) },
                            ifFalse = { null }
                    )
                }
                .observe { executor = it }
    }

    override fun invoke(
            coroutine: suspend CoroutineScope.() -> Unit
    ) {
        executor?.invoke(coroutine)?.ifTrue { return }
        launchWithoutExecutor(coroutine)
    }

    private fun launchWithoutExecutor(
            coroutine: suspend CoroutineScope.() -> Unit
    ) {
        val cancellableContext = cancellableContextCreator()
        val finishableExecutor = FinishableExecutor(cancellableContext)
        finishableExecutor.invoke(coroutine).ifFalse { throw IllegalStateException("It should not have happened") }
        executorsFinisher.finishExecutor(finishableExecutor)
    }

}