/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.holoeverywhere.resbuilder.ResMojo;
import org.holoeverywhere.resbuilder.type.FileProcesser;

public class BuildMojo
extends ResMojo {
    private static final FileFilter BUILD_ALL_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().length() > 5 && pathname.getName().endsWith(".json");
        }
    };

    public void execute() throws MojoExecutionException, MojoFailureException {
        String path;
        if (this.skip) {
            this.getLog().info((CharSequence)"Flag 'Skip' is true");
            return;
        }
        if (!(this.androidSdkPath != null && this.androidSdkPath.exists() || (path = System.getenv("ANDROID_HOME")) == null)) {
            this.androidSdkPath = new File(path);
        }
        if (this.androidSdkPath == null || !this.androidSdkPath.exists()) {
            throw new MojoExecutionException("Couldn't find Android SDK by path: " + this.androidSdkPath);
        }
        if (this.buildAll) {
            if (this.includeDirs == null || this.includeDirs.length == 0) {
                this.getLog().warn((CharSequence)"BuildAll: You want build all files from all include dirs, but you don't specify any include dir. Nothing to build. Skip.");
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (File dir : this.includeDirs) {
                File[] files;
                for (File file : files = dir.listFiles(BUILD_ALL_FILTER)) {
                    this.getLog().info((CharSequence)("BuildAll: add " + file.getAbsolutePath()));
                    list.add(file.getAbsolutePath());
                }
            }
            if (this.inputFiles != null && this.inputFiles.length > 0) {
                list.addAll(0, Arrays.asList(this.inputFiles));
            }
            this.inputFiles = list.toArray(new String[list.size()]);
            if (this.inputFiles.length == 0) {
                this.getLog().info((CharSequence)"BuildAll: nothing to build");
                return;
            }
        }
        if (this.inputFiles == null || this.inputFiles.length == 0) {
            this.getLog().info((CharSequence)"Don't specify input files, skip");
            return;
        }
        if (!this.buildAll && this.includeDirs == null || this.includeDirs.length == 0) {
            this.getLog().warn((CharSequence)"Include dirs don't specified");
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Final configuration:");
            this.getLog().info((CharSequence)(" # androidSdkPath: " + this.androidSdkPath));
            this.getLog().info((CharSequence)(" # androidSdkVersion: " + this.androidSdkVersion));
            if (this.includeDirs == null || this.includeDirs.length == 0) {
                this.getLog().info((CharSequence)" # includeDirs: empty");
            } else {
                this.getLog().info((CharSequence)" # includeDirs: [");
                for (File dir : this.includeDirs) {
                    this.getLog().info((CharSequence)(" # # " + dir.getAbsolutePath()));
                }
                this.getLog().info((CharSequence)" # ]");
            }
            if (this.inputFiles == null || this.inputFiles.length == 0) {
                this.getLog().info((CharSequence)" # input: empty");
            } else {
                this.getLog().info((CharSequence)" # input: [");
                for (String input : this.inputFiles) {
                    this.getLog().info((CharSequence)(" # # " + (String)input));
                }
                this.getLog().info((CharSequence)" # ]");
            }
            this.getLog().info((CharSequence)(" # outputDir: " + this.outputDir));
        }
        try {
            FileProcesser.process(this);
        }
        catch (FileProcesser.FileProcesserException e) {
            throw new MojoFailureException("Error in FileProcesser", (Throwable)e);
        }
    }
}

