/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder.type;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.holoeverywhere.resbuilder.BuildMojo;
import org.holoeverywhere.resbuilder.type.TypeProcesser;
import org.holoeverywhere.resbuilder.type.attrs.TypeAttrs;
import org.holoeverywhere.resbuilder.type.strings.TypeStrings;
import org.holoeverywhere.resbuilder.type.styles.TypeStyles;
import org.json.JSONObject;

public class FileProcesser {
    private static final Map<String, TypeProcesser> PROCESSERS_MAP = new HashMap<String, TypeProcesser>();
    private final Map<File, ProcessResult> mCache = new HashMap<File, ProcessResult>();
    private BuildMojo mojo;

    public static void process(BuildMojo mojo) throws FileProcesserException {
        new FileProcesser(mojo).process();
    }

    public static void registerProcesser(Class<? extends TypeProcesser> clazz) {
        try {
            TypeProcesser processer = clazz.newInstance();
            PROCESSERS_MAP.put(processer.getType(), processer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public FileProcesser(BuildMojo mojo) {
        this.setMojo(mojo);
    }

    private ProcessResult cache(File file, ProcessResult result) {
        this.mCache.put(file, result);
        return result;
    }

    public BuildMojo getMojo() {
        return this.mojo;
    }

    public void process() throws FileProcesserException {
        ProcessResult result = new ProcessResult();
        for (String input : this.mojo.inputFiles) {
            result.add(this.process(input));
        }
        result.flush(this.mojo);
    }

    public ProcessResult process(File file) throws FileProcesserException {
        return this.process(file, null);
    }

    public ProcessResult process(File file, String forceType) throws FileProcesserException {
        ProcessResult result = this.mCache.get(file);
        if (result != null) {
            return result;
        }
        try {
            this.mojo.getLog().info((CharSequence)("Process file: " + file.getAbsolutePath()));
            String fileContent = this.readFile(file);
            JSONObject json = new JSONObject(fileContent);
            if (forceType != null) {
                this.mojo.getLog().info((CharSequence)("Handle all file by key '" + forceType + "' (force)"));
                return this.cache(file, this.process(forceType, json));
            }
            if (file.getName().startsWith("key_")) {
                String key;
                int c = (key = file.getName()).lastIndexOf(46);
                key = key.substring(4, c > 0 ? c : key.length());
                this.mojo.getLog().info((CharSequence)("Handle all file by key '" + key + "'"));
                return this.cache(file, this.process(key, json));
            }
            result = new ProcessResult();
            Iterator keys = json.sortedKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                ProcessResult subResult = this.process(key, json.optJSONObject(key));
                if (subResult == null) continue;
                result.add(subResult);
            }
            return this.cache(file, result);
        }
        catch (Exception e) {
            throw new FileProcesserException(e);
        }
    }

    public ProcessResult process(String filename) throws FileProcesserException {
        File file;
        String forceType = null;
        int c = filename.lastIndexOf(58);
        if (c > 0) {
            forceType = filename.substring(c + 1);
            filename = filename.substring(0, c);
        }
        for (File includeDir : this.mojo.includeDirs) {
            file = new File(includeDir, filename);
            if (!file.exists()) continue;
            return this.process(file, forceType);
        }
        file = new File(filename);
        if (file.exists()) {
            return this.process(file, forceType);
        }
        throw new FileProcesserException("Couldn't find file for processing: " + filename);
    }

    public ProcessResult process(String key, JSONObject json) throws FileProcesserException {
        TypeProcesser processer = PROCESSERS_MAP.get(key);
        if (processer == null) {
            this.mojo.getLog().warn((CharSequence)(" # Couldn't find processer for key '" + key + "', skip"));
            return null;
        }
        this.mojo.getLog().info((CharSequence)(" # Handle key '" + key + "' to processer '" + processer.getName() + "'"));
        ProcessResult subResult = processer.process(this.mojo, json);
        if (subResult == null) {
            String message = "Processer " + processer.getClass().getName() + " return null result";
            this.mojo.getLog().error((CharSequence)(" # " + message));
            throw new FileProcesserException(message);
        }
        return subResult;
    }

    private String readFile(File file) throws IOException {
        int c;
        FileInputStream is = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "utf-8"));
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        while ((c = reader.read(buffer)) > 0) {
            builder.append(buffer, 0, c);
        }
        ((Reader)reader).close();
        ((InputStream)is).close();
        return builder.toString();
    }

    public void setMojo(BuildMojo mojo) {
        this.mojo = mojo;
        this.mojo.processer = this;
    }

    static {
        FileProcesser.registerProcesser(TypeStrings.class);
        FileProcesser.registerProcesser(TypeStyles.class);
        FileProcesser.registerProcesser(TypeAttrs.class);
    }

    public static class ProcessResult
    extends ArrayList<ProcessResult> {
        private static final long serialVersionUID = 6761878269956927443L;
        private static final Transformer TRANSFORMER;
        private static final TransformerFactory TRANSFORMER_FACTORY;
        private static final Map<File, WriterState> WRITERS_MAP;
        private static final XMLOutputFactory XML_OUTPUT_FACTORY;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close(BuildMojo mojo) throws FileProcesserException {
            for (ProcessResult child : this) {
                child.close(mojo);
            }
            try {
                Map<File, WriterState> i$ = WRITERS_MAP;
                synchronized (i$) {
                    for (WriterState state : WRITERS_MAP.values()) {
                        state.writer.writeEndElement();
                        state.writer.writeEndDocument();
                        state.writer.flush();
                        state.writer.close();
                        TRANSFORMER.transform(new StreamSource(new StringReader(state.tempWriter.toString())), new StreamResult(new FileOutputStream(state.file)));
                    }
                    WRITERS_MAP.clear();
                }
            }
            catch (Exception e) {
                throw new FileProcesserException(e);
            }
        }

        public <T extends ProcessResult> T find(Class<T> clazz) {
            if (clazz.isAssignableFrom(this.getClass())) {
                return (T)this;
            }
            for (ProcessResult child : this) {
                T result = child.find(clazz);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public void flush(BuildMojo mojo) throws FileProcesserException {
            for (ProcessResult child : this) {
                child.flush(mojo);
            }
            this.close(mojo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected XMLStreamWriter openWriter(BuildMojo mojo, File dir, String filename) throws FileProcesserException {
            try {
                WriterState state;
                File file;
                if (dir == null) {
                    dir = mojo.outputDir;
                }
                if (!(dir = (file = new File(dir, filename)).getParentFile()).exists()) {
                    if (mojo.verbose) {
                        mojo.getLog().info((CharSequence)("Create new folder: " + dir.getAbsolutePath()));
                    }
                    dir.mkdirs();
                }
                Map<File, WriterState> map = WRITERS_MAP;
                synchronized (map) {
                    state = WRITERS_MAP.get(file);
                    if (state == null) {
                        if (mojo.verbose) {
                            mojo.getLog().info((CharSequence)(" # Flush data to file " + file.getAbsolutePath()));
                        }
                        state = new WriterState();
                        state.file = file;
                        state.tempWriter = new StringWriter();
                        state.writer = ProcessResult.XML_OUTPUT_FACTORY.createXMLStreamWriter(state.tempWriter);
                        state.writer.writeStartDocument("utf-8", "1.0");
                        state.writer.writeStartElement("resources");
                        WRITERS_MAP.put(file, state);
                    }
                }
                return state.writer;
            }
            catch (Exception e) {
                throw new FileProcesserException(e);
            }
        }

        static {
            WRITERS_MAP = new HashMap<File, WriterState>();
            XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
            TRANSFORMER_FACTORY = TransformerFactory.newInstance();
            Transformer transformer = null;
            try {
                transformer = TRANSFORMER_FACTORY.newTransformer();
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "utf-8");
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            TRANSFORMER = transformer;
        }

        private static final class WriterState {
            private File file;
            private StringWriter tempWriter;
            private XMLStreamWriter writer;

            private WriterState() {
            }
        }
    }

    public static class FileProcesserException
    extends Exception {
        private static final long serialVersionUID = 3229067373448702029L;

        public FileProcesserException(String message) {
            super(message);
        }

        public FileProcesserException(Throwable cause) {
            super(cause);
        }
    }
}

