/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.resbuilder.type;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.holoeverywhere.resbuilder.BuildMojo;
import org.holoeverywhere.resbuilder.type.FileProcesser;
import org.json.JSONObject;

public abstract class TypeProcesser {
    private final String type;
    private final String name;

    public TypeProcesser() {
        Class<?> clazz = this.getClass();
        if (!clazz.isAnnotationPresent(Type.class)) {
            throw new IllegalStateException("TypeProcesser should be present Type annotation");
        }
        Type type = clazz.getAnnotation(Type.class);
        String name = type.name();
        if (name.length() == 0 && (name = clazz.getSimpleName()).startsWith("Type") && name.length() > 4) {
            name = name.substring(4);
        }
        this.name = name;
        this.type = type.value();
    }

    public final String getName() {
        return this.name;
    }

    public final String getType() {
        return this.type;
    }

    public abstract FileProcesser.ProcessResult process(BuildMojo var1, JSONObject var2);

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface Type {
        public String name() default "";

        public String value();
    }
}

